/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_2.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.authentication.v1alpha1.PolicySpec;
import me.snowdrop.istio.api.authentication.v1alpha1.PolicySpecFluent;
import me.snowdrop.istio.api.authentication.v1alpha1.PolicySpecFluentImpl;

public class PolicySpecBuilder
extends PolicySpecFluentImpl<PolicySpecBuilder>
implements VisitableBuilder<PolicySpec, PolicySpecBuilder> {
    PolicySpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PolicySpecBuilder() {
        this(true);
    }

    public PolicySpecBuilder(Boolean validationEnabled) {
        this(new PolicySpec(), validationEnabled);
    }

    public PolicySpecBuilder(PolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PolicySpecBuilder(PolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PolicySpec(), validationEnabled);
    }

    public PolicySpecBuilder(PolicySpecFluent<?> fluent, PolicySpec instance) {
        this(fluent, instance, true);
    }

    public PolicySpecBuilder(PolicySpecFluent<?> fluent, PolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withOriginIsOptional(instance.getOriginIsOptional());
        fluent.withOrigins(instance.getOrigins());
        fluent.withPeerIsOptional(instance.getPeerIsOptional());
        fluent.withPeers(instance.getPeers());
        fluent.withPrincipalBinding(instance.getPrincipalBinding());
        fluent.withTargets(instance.getTargets());
        this.validationEnabled = validationEnabled;
    }

    public PolicySpecBuilder(PolicySpec instance) {
        this(instance, (Boolean)true);
    }

    public PolicySpecBuilder(PolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withOriginIsOptional(instance.getOriginIsOptional());
        this.withOrigins(instance.getOrigins());
        this.withPeerIsOptional(instance.getPeerIsOptional());
        this.withPeers(instance.getPeers());
        this.withPrincipalBinding(instance.getPrincipalBinding());
        this.withTargets(instance.getTargets());
        this.validationEnabled = validationEnabled;
    }

    public PolicySpecBuilder(Validator validator) {
        this(new PolicySpec(), (Boolean)true);
    }

    public PolicySpecBuilder(PolicySpecFluent<?> fluent, PolicySpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withOriginIsOptional(instance.getOriginIsOptional());
        fluent.withOrigins(instance.getOrigins());
        fluent.withPeerIsOptional(instance.getPeerIsOptional());
        fluent.withPeers(instance.getPeers());
        fluent.withPrincipalBinding(instance.getPrincipalBinding());
        fluent.withTargets(instance.getTargets());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PolicySpecBuilder(PolicySpec instance, Validator validator) {
        this.fluent = this;
        this.withOriginIsOptional(instance.getOriginIsOptional());
        this.withOrigins(instance.getOrigins());
        this.withPeerIsOptional(instance.getPeerIsOptional());
        this.withPeers(instance.getPeers());
        this.withPrincipalBinding(instance.getPrincipalBinding());
        this.withTargets(instance.getTargets());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PolicySpec build() {
        PolicySpec buildable = new PolicySpec(this.fluent.isOriginIsOptional(), this.fluent.getOrigins(), this.fluent.isPeerIsOptional(), this.fluent.getPeers(), this.fluent.getPrincipalBinding(), this.fluent.getTargets());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicySpecBuilder that = (PolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

