/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.authentication.v1alpha1.Jwt;
import me.snowdrop.istio.api.authentication.v1alpha1.JwtFluent;
import me.snowdrop.istio.api.authentication.v1alpha1.TriggerRule;
import me.snowdrop.istio.api.authentication.v1alpha1.TriggerRuleBuilder;
import me.snowdrop.istio.api.authentication.v1alpha1.TriggerRuleFluentImpl;

public class JwtFluentImpl<A extends JwtFluent<A>>
extends BaseFluent<A>
implements JwtFluent<A> {
    private List<String> audiences;
    private String issuer;
    private String jwksUri;
    private List<String> jwtHeaders;
    private List<String> jwtParams;
    private List<TriggerRuleBuilder> triggerRules;

    public JwtFluentImpl() {
    }

    public JwtFluentImpl(Jwt instance) {
        this.withAudiences(instance.getAudiences());
        this.withIssuer(instance.getIssuer());
        this.withJwksUri(instance.getJwksUri());
        this.withJwtHeaders(instance.getJwtHeaders());
        this.withJwtParams(instance.getJwtParams());
        this.withTriggerRules(instance.getTriggerRules());
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (this.audiences != null) {
            this._visitables.get((Object)"audiences").removeAll(this.audiences);
        }
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuilder arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuffer arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    @Override
    public Boolean hasIssuer() {
        return this.issuer != null;
    }

    @Override
    public A withNewIssuer(String arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(StringBuilder arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(StringBuffer arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    public A withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return (A)this;
    }

    @Override
    public Boolean hasJwksUri() {
        return this.jwksUri != null;
    }

    @Override
    public A withNewJwksUri(String arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public A withNewJwksUri(StringBuilder arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public A withNewJwksUri(StringBuffer arg1) {
        return this.withJwksUri(new String(arg1));
    }

    @Override
    public A addToJwtHeaders(int index, String item) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        this.jwtHeaders.add(index, item);
        return (A)this;
    }

    @Override
    public A setToJwtHeaders(int index, String item) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        this.jwtHeaders.set(index, item);
        return (A)this;
    }

    @Override
    public A addToJwtHeaders(String ... items) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtHeaders.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToJwtHeaders(Collection<String> items) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtHeaders.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromJwtHeaders(String ... items) {
        for (String item : items) {
            if (this.jwtHeaders == null) continue;
            this.jwtHeaders.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJwtHeaders(Collection<String> items) {
        for (String item : items) {
            if (this.jwtHeaders == null) continue;
            this.jwtHeaders.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getJwtHeaders() {
        return this.jwtHeaders;
    }

    @Override
    public String getJwtHeader(int index) {
        return this.jwtHeaders.get(index);
    }

    @Override
    public String getFirstJwtHeader() {
        return this.jwtHeaders.get(0);
    }

    @Override
    public String getLastJwtHeader() {
        return this.jwtHeaders.get(this.jwtHeaders.size() - 1);
    }

    @Override
    public String getMatchingJwtHeader(Predicate<String> predicate) {
        for (String item : this.jwtHeaders) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingJwtHeader(Predicate<String> predicate) {
        for (String item : this.jwtHeaders) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withJwtHeaders(List<String> jwtHeaders) {
        if (this.jwtHeaders != null) {
            this._visitables.get((Object)"jwtHeaders").removeAll(this.jwtHeaders);
        }
        if (jwtHeaders != null) {
            this.jwtHeaders = new ArrayList<String>();
            for (String item : jwtHeaders) {
                this.addToJwtHeaders(item);
            }
        } else {
            this.jwtHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withJwtHeaders(String ... jwtHeaders) {
        if (this.jwtHeaders != null) {
            this.jwtHeaders.clear();
        }
        if (jwtHeaders != null) {
            for (String item : jwtHeaders) {
                this.addToJwtHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJwtHeaders() {
        return this.jwtHeaders != null && !this.jwtHeaders.isEmpty();
    }

    @Override
    public A addNewJwtHeader(String arg1) {
        return this.addToJwtHeaders(new String(arg1));
    }

    @Override
    public A addNewJwtHeader(StringBuilder arg1) {
        return this.addToJwtHeaders(new String(arg1));
    }

    @Override
    public A addNewJwtHeader(StringBuffer arg1) {
        return this.addToJwtHeaders(new String(arg1));
    }

    @Override
    public A addToJwtParams(int index, String item) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        this.jwtParams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToJwtParams(int index, String item) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        this.jwtParams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToJwtParams(String ... items) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToJwtParams(Collection<String> items) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromJwtParams(String ... items) {
        for (String item : items) {
            if (this.jwtParams == null) continue;
            this.jwtParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJwtParams(Collection<String> items) {
        for (String item : items) {
            if (this.jwtParams == null) continue;
            this.jwtParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getJwtParams() {
        return this.jwtParams;
    }

    @Override
    public String getJwtParam(int index) {
        return this.jwtParams.get(index);
    }

    @Override
    public String getFirstJwtParam() {
        return this.jwtParams.get(0);
    }

    @Override
    public String getLastJwtParam() {
        return this.jwtParams.get(this.jwtParams.size() - 1);
    }

    @Override
    public String getMatchingJwtParam(Predicate<String> predicate) {
        for (String item : this.jwtParams) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingJwtParam(Predicate<String> predicate) {
        for (String item : this.jwtParams) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withJwtParams(List<String> jwtParams) {
        if (this.jwtParams != null) {
            this._visitables.get((Object)"jwtParams").removeAll(this.jwtParams);
        }
        if (jwtParams != null) {
            this.jwtParams = new ArrayList<String>();
            for (String item : jwtParams) {
                this.addToJwtParams(item);
            }
        } else {
            this.jwtParams = null;
        }
        return (A)this;
    }

    @Override
    public A withJwtParams(String ... jwtParams) {
        if (this.jwtParams != null) {
            this.jwtParams.clear();
        }
        if (jwtParams != null) {
            for (String item : jwtParams) {
                this.addToJwtParams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJwtParams() {
        return this.jwtParams != null && !this.jwtParams.isEmpty();
    }

    @Override
    public A addNewJwtParam(String arg1) {
        return this.addToJwtParams(new String(arg1));
    }

    @Override
    public A addNewJwtParam(StringBuilder arg1) {
        return this.addToJwtParams(new String(arg1));
    }

    @Override
    public A addNewJwtParam(StringBuffer arg1) {
        return this.addToJwtParams(new String(arg1));
    }

    @Override
    public A addToTriggerRules(int index, TriggerRule item) {
        if (this.triggerRules == null) {
            this.triggerRules = new ArrayList<TriggerRuleBuilder>();
        }
        TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
        this._visitables.get((Object)"triggerRules").add(index >= 0 ? index : this._visitables.get((Object)"triggerRules").size(), builder);
        this.triggerRules.add(index >= 0 ? index : this.triggerRules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggerRules(int index, TriggerRule item) {
        if (this.triggerRules == null) {
            this.triggerRules = new ArrayList<TriggerRuleBuilder>();
        }
        TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"triggerRules").size()) {
            this._visitables.get((Object)"triggerRules").add(builder);
        } else {
            this._visitables.get((Object)"triggerRules").set(index, builder);
        }
        if (index < 0 || index >= this.triggerRules.size()) {
            this.triggerRules.add(builder);
        } else {
            this.triggerRules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggerRules(TriggerRule ... items) {
        if (this.triggerRules == null) {
            this.triggerRules = new ArrayList<TriggerRuleBuilder>();
        }
        for (TriggerRule item : items) {
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
            this._visitables.get((Object)"triggerRules").add(builder);
            this.triggerRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggerRules(Collection<TriggerRule> items) {
        if (this.triggerRules == null) {
            this.triggerRules = new ArrayList<TriggerRuleBuilder>();
        }
        for (TriggerRule item : items) {
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
            this._visitables.get((Object)"triggerRules").add(builder);
            this.triggerRules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggerRules(TriggerRule ... items) {
        for (TriggerRule item : items) {
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
            this._visitables.get((Object)"triggerRules").remove(builder);
            if (this.triggerRules == null) continue;
            this.triggerRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggerRules(Collection<TriggerRule> items) {
        for (TriggerRule item : items) {
            TriggerRuleBuilder builder = new TriggerRuleBuilder(item);
            this._visitables.get((Object)"triggerRules").remove(builder);
            if (this.triggerRules == null) continue;
            this.triggerRules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TriggerRule> getTriggerRules() {
        return JwtFluentImpl.build(this.triggerRules);
    }

    @Override
    public List<TriggerRule> buildTriggerRules() {
        return JwtFluentImpl.build(this.triggerRules);
    }

    @Override
    public TriggerRule buildTriggerRule(int index) {
        return this.triggerRules.get(index).build();
    }

    @Override
    public TriggerRule buildFirstTriggerRule() {
        return this.triggerRules.get(0).build();
    }

    @Override
    public TriggerRule buildLastTriggerRule() {
        return this.triggerRules.get(this.triggerRules.size() - 1).build();
    }

    @Override
    public TriggerRule buildMatchingTriggerRule(Predicate<TriggerRuleBuilder> predicate) {
        for (TriggerRuleBuilder item : this.triggerRules) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTriggerRule(Predicate<TriggerRuleBuilder> predicate) {
        for (TriggerRuleBuilder item : this.triggerRules) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTriggerRules(List<TriggerRule> triggerRules) {
        if (this.triggerRules != null) {
            this._visitables.get((Object)"triggerRules").removeAll(this.triggerRules);
        }
        if (triggerRules != null) {
            this.triggerRules = new ArrayList<TriggerRuleBuilder>();
            for (TriggerRule item : triggerRules) {
                this.addToTriggerRules(item);
            }
        } else {
            this.triggerRules = null;
        }
        return (A)this;
    }

    @Override
    public A withTriggerRules(TriggerRule ... triggerRules) {
        if (this.triggerRules != null) {
            this.triggerRules.clear();
        }
        if (triggerRules != null) {
            for (TriggerRule item : triggerRules) {
                this.addToTriggerRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggerRules() {
        return this.triggerRules != null && !this.triggerRules.isEmpty();
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> addNewTriggerRule() {
        return new TriggerRulesNestedImpl();
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> addNewTriggerRuleLike(TriggerRule item) {
        return new TriggerRulesNestedImpl(-1, item);
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> setNewTriggerRuleLike(int index, TriggerRule item) {
        return new TriggerRulesNestedImpl(index, item);
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> editTriggerRule(int index) {
        if (this.triggerRules.size() <= index) {
            throw new RuntimeException("Can't edit triggerRules. Index exceeds size.");
        }
        return this.setNewTriggerRuleLike(index, this.buildTriggerRule(index));
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> editFirstTriggerRule() {
        if (this.triggerRules.size() == 0) {
            throw new RuntimeException("Can't edit first triggerRules. The list is empty.");
        }
        return this.setNewTriggerRuleLike(0, this.buildTriggerRule(0));
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> editLastTriggerRule() {
        int index = this.triggerRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggerRules. The list is empty.");
        }
        return this.setNewTriggerRuleLike(index, this.buildTriggerRule(index));
    }

    @Override
    public JwtFluent.TriggerRulesNested<A> editMatchingTriggerRule(Predicate<TriggerRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggerRules.size(); ++i) {
            if (!predicate.apply((Object)this.triggerRules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggerRules. No match found.");
        }
        return this.setNewTriggerRuleLike(index, this.buildTriggerRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtFluentImpl that = (JwtFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) {
            return false;
        }
        if (this.jwksUri != null ? !this.jwksUri.equals(that.jwksUri) : that.jwksUri != null) {
            return false;
        }
        if (this.jwtHeaders != null ? !this.jwtHeaders.equals(that.jwtHeaders) : that.jwtHeaders != null) {
            return false;
        }
        if (this.jwtParams != null ? !this.jwtParams.equals(that.jwtParams) : that.jwtParams != null) {
            return false;
        }
        return !(this.triggerRules != null ? !this.triggerRules.equals(that.triggerRules) : that.triggerRules != null);
    }

    public class TriggerRulesNestedImpl<N>
    extends TriggerRuleFluentImpl<JwtFluent.TriggerRulesNested<N>>
    implements JwtFluent.TriggerRulesNested<N>,
    Nested<N> {
        private final TriggerRuleBuilder builder;
        private final int index;

        TriggerRulesNestedImpl(int index, TriggerRule item) {
            this.index = index;
            this.builder = new TriggerRuleBuilder(this, item);
        }

        TriggerRulesNestedImpl() {
            this.index = -1;
            this.builder = new TriggerRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)JwtFluentImpl.this.setToTriggerRules(this.index, this.builder.build());
        }

        @Override
        public N endTriggerRule() {
            return this.and();
        }
    }
}

