/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.template.metric;

import io.fabric8.kubernetes.api.builder.v4_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_2.Nested;
import io.fabric8.kubernetes.api.builder.v4_2.Predicate;
import io.fabric8.kubernetes.api.model.v4_2.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.template.metric.MetricBuilder;
import me.snowdrop.istio.mixer.template.metric.MetricFluentImpl;
import me.snowdrop.istio.mixer.template.metric.MetricList;
import me.snowdrop.istio.mixer.template.metric.MetricListFluent;

public class MetricListFluentImpl<A extends MetricListFluent<A>>
extends BaseFluent<A>
implements MetricListFluent<A> {
    private String apiVersion;
    private List<MetricBuilder> items;
    private String kind;
    private ListMeta metadata;

    public MetricListFluentImpl() {
    }

    public MetricListFluentImpl(MetricList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, Metric item) {
        if (this.items == null) {
            this.items = new ArrayList<MetricBuilder>();
        }
        MetricBuilder builder = new MetricBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, Metric item) {
        if (this.items == null) {
            this.items = new ArrayList<MetricBuilder>();
        }
        MetricBuilder builder = new MetricBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Metric ... items) {
        if (this.items == null) {
            this.items = new ArrayList<MetricBuilder>();
        }
        for (Metric item : items) {
            MetricBuilder builder = new MetricBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Metric> items) {
        if (this.items == null) {
            this.items = new ArrayList<MetricBuilder>();
        }
        for (Metric item : items) {
            MetricBuilder builder = new MetricBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Metric ... items) {
        for (Metric item : items) {
            MetricBuilder builder = new MetricBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Metric> items) {
        for (Metric item : items) {
            MetricBuilder builder = new MetricBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Metric> getItems() {
        return MetricListFluentImpl.build(this.items);
    }

    @Override
    public List<Metric> buildItems() {
        return MetricListFluentImpl.build(this.items);
    }

    @Override
    public Metric buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public Metric buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Metric buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Metric buildMatchingItem(Predicate<MetricBuilder> predicate) {
        for (MetricBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<MetricBuilder> predicate) {
        for (MetricBuilder item : this.items) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<Metric> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<MetricBuilder>();
            for (Metric item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(Metric ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Metric item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public MetricListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public MetricListFluent.ItemsNested<A> addNewItemLike(Metric item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public MetricListFluent.ItemsNested<A> setNewItemLike(int index, Metric item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public MetricListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public MetricListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public MetricListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public MetricListFluent.ItemsNested<A> editMatchingItem(Predicate<MetricBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply((Object)this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricListFluentImpl that = (MetricListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public class ItemsNestedImpl<N>
    extends MetricFluentImpl<MetricListFluent.ItemsNested<N>>
    implements MetricListFluent.ItemsNested<N>,
    Nested<N> {
        private final MetricBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, Metric item) {
            this.index = index;
            this.builder = new MetricBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new MetricBuilder(this);
        }

        @Override
        public N and() {
            return (N)MetricListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

