/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.signalfx;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.mixer.adapter.signalfx.MetricConfig;
import me.snowdrop.istio.mixer.adapter.signalfx.MetricConfigBuilder;
import me.snowdrop.istio.mixer.adapter.signalfx.MetricConfigFluentImpl;
import me.snowdrop.istio.mixer.adapter.signalfx.SignalfxSpec;
import me.snowdrop.istio.mixer.adapter.signalfx.SignalfxSpecFluent;

public class SignalfxSpecFluentImpl<A extends SignalfxSpecFluent<A>>
extends BaseFluent<A>
implements SignalfxSpecFluent<A> {
    private String accessToken;
    private Integer datapointInterval;
    private Boolean enableMetrics;
    private Boolean enableTracing;
    private String ingestUrl;
    private List<MetricConfigBuilder> metrics;
    private Integer tracingBufferSize;
    private Double tracingSampleProbability;

    public SignalfxSpecFluentImpl() {
    }

    public SignalfxSpecFluentImpl(SignalfxSpec instance) {
        this.withAccessToken(instance.getAccessToken());
        this.withDatapointInterval(instance.getDatapointInterval());
        this.withEnableMetrics(instance.getEnableMetrics());
        this.withEnableTracing(instance.getEnableTracing());
        this.withIngestUrl(instance.getIngestUrl());
        this.withMetrics(instance.getMetrics());
        this.withTracingBufferSize(instance.getTracingBufferSize());
        this.withTracingSampleProbability(instance.getTracingSampleProbability());
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public A withAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return (A)this;
    }

    @Override
    public Boolean hasAccessToken() {
        return this.accessToken != null;
    }

    @Override
    public Integer getDatapointInterval() {
        return this.datapointInterval;
    }

    @Override
    public A withDatapointInterval(Integer datapointInterval) {
        this.datapointInterval = datapointInterval;
        return (A)this;
    }

    @Override
    public Boolean hasDatapointInterval() {
        return this.datapointInterval != null;
    }

    @Override
    public A withNewDatapointInterval(String arg1) {
        return this.withDatapointInterval(new Integer(arg1));
    }

    @Override
    public A withNewDatapointInterval(int arg1) {
        return this.withDatapointInterval(new Integer(arg1));
    }

    @Override
    public Boolean isEnableMetrics() {
        return this.enableMetrics;
    }

    @Override
    public A withEnableMetrics(Boolean enableMetrics) {
        this.enableMetrics = enableMetrics;
        return (A)this;
    }

    @Override
    public Boolean hasEnableMetrics() {
        return this.enableMetrics != null;
    }

    @Override
    public A withNewEnableMetrics(String arg1) {
        return this.withEnableMetrics(new Boolean(arg1));
    }

    @Override
    public A withNewEnableMetrics(boolean arg1) {
        return this.withEnableMetrics(new Boolean(arg1));
    }

    @Override
    public Boolean isEnableTracing() {
        return this.enableTracing;
    }

    @Override
    public A withEnableTracing(Boolean enableTracing) {
        this.enableTracing = enableTracing;
        return (A)this;
    }

    @Override
    public Boolean hasEnableTracing() {
        return this.enableTracing != null;
    }

    @Override
    public A withNewEnableTracing(String arg1) {
        return this.withEnableTracing(new Boolean(arg1));
    }

    @Override
    public A withNewEnableTracing(boolean arg1) {
        return this.withEnableTracing(new Boolean(arg1));
    }

    @Override
    public String getIngestUrl() {
        return this.ingestUrl;
    }

    @Override
    public A withIngestUrl(String ingestUrl) {
        this.ingestUrl = ingestUrl;
        return (A)this;
    }

    @Override
    public Boolean hasIngestUrl() {
        return this.ingestUrl != null;
    }

    @Override
    public A addToMetrics(int index, MetricConfig item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricConfigBuilder>();
        }
        MetricConfigBuilder builder = new MetricConfigBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.metrics.add(index >= 0 ? index : this.metrics.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetrics(int index, MetricConfig item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricConfigBuilder>();
        }
        MetricConfigBuilder builder = new MetricConfigBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.metrics.size()) {
            this.metrics.add(builder);
        } else {
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetrics(MetricConfig ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricConfigBuilder>();
        }
        for (MetricConfig item : items) {
            MetricConfigBuilder builder = new MetricConfigBuilder(item);
            this._visitables.add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetrics(Collection<MetricConfig> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricConfigBuilder>();
        }
        for (MetricConfig item : items) {
            MetricConfigBuilder builder = new MetricConfigBuilder(item);
            this._visitables.add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetrics(MetricConfig ... items) {
        for (MetricConfig item : items) {
            MetricConfigBuilder builder = new MetricConfigBuilder(item);
            this._visitables.remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetrics(Collection<MetricConfig> items) {
        for (MetricConfig item : items) {
            MetricConfigBuilder builder = new MetricConfigBuilder(item);
            this._visitables.remove(builder);
            if (this.metrics == null) continue;
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MetricConfig> getMetrics() {
        return SignalfxSpecFluentImpl.build(this.metrics);
    }

    @Override
    public List<MetricConfig> buildMetrics() {
        return SignalfxSpecFluentImpl.build(this.metrics);
    }

    @Override
    public MetricConfig buildMetric(int index) {
        return this.metrics.get(index).build();
    }

    @Override
    public MetricConfig buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    @Override
    public MetricConfig buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    @Override
    public MetricConfig buildMatchingMetric(Predicate<MetricConfigBuilder> predicate) {
        for (MetricConfigBuilder item : this.metrics) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withMetrics(List<MetricConfig> metrics) {
        if (this.metrics != null) {
            this._visitables.removeAll(this.metrics);
        }
        if (metrics != null) {
            this.metrics = new ArrayList<MetricConfigBuilder>();
            for (MetricConfig item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    @Override
    public A withMetrics(MetricConfig ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
        }
        if (metrics != null) {
            for (MetricConfig item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> addNewMetricLike(MetricConfig item) {
        return new MetricsNestedImpl(-1, item);
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> setNewMetricLike(int index, MetricConfig item) {
        return new MetricsNestedImpl(index, item);
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> editMetric(int index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public SignalfxSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<MetricConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.apply((Object)this.metrics.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    @Override
    public Integer getTracingBufferSize() {
        return this.tracingBufferSize;
    }

    @Override
    public A withTracingBufferSize(Integer tracingBufferSize) {
        this.tracingBufferSize = tracingBufferSize;
        return (A)this;
    }

    @Override
    public Boolean hasTracingBufferSize() {
        return this.tracingBufferSize != null;
    }

    @Override
    public A withNewTracingBufferSize(String arg1) {
        return this.withTracingBufferSize(new Integer(arg1));
    }

    @Override
    public A withNewTracingBufferSize(int arg1) {
        return this.withTracingBufferSize(new Integer(arg1));
    }

    @Override
    public Double getTracingSampleProbability() {
        return this.tracingSampleProbability;
    }

    @Override
    public A withTracingSampleProbability(Double tracingSampleProbability) {
        this.tracingSampleProbability = tracingSampleProbability;
        return (A)this;
    }

    @Override
    public Boolean hasTracingSampleProbability() {
        return this.tracingSampleProbability != null;
    }

    @Override
    public A withNewTracingSampleProbability(String arg1) {
        return this.withTracingSampleProbability(new Double(arg1));
    }

    @Override
    public A withNewTracingSampleProbability(double arg1) {
        return this.withTracingSampleProbability(new Double(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SignalfxSpecFluentImpl that = (SignalfxSpecFluentImpl)o;
        if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) {
            return false;
        }
        if (this.datapointInterval != null ? !this.datapointInterval.equals(that.datapointInterval) : that.datapointInterval != null) {
            return false;
        }
        if (this.enableMetrics != null ? !this.enableMetrics.equals(that.enableMetrics) : that.enableMetrics != null) {
            return false;
        }
        if (this.enableTracing != null ? !this.enableTracing.equals(that.enableTracing) : that.enableTracing != null) {
            return false;
        }
        if (this.ingestUrl != null ? !this.ingestUrl.equals(that.ingestUrl) : that.ingestUrl != null) {
            return false;
        }
        if (this.metrics != null ? !this.metrics.equals(that.metrics) : that.metrics != null) {
            return false;
        }
        if (this.tracingBufferSize != null ? !this.tracingBufferSize.equals(that.tracingBufferSize) : that.tracingBufferSize != null) {
            return false;
        }
        return !(this.tracingSampleProbability != null ? !this.tracingSampleProbability.equals(that.tracingSampleProbability) : that.tracingSampleProbability != null);
    }

    public class MetricsNestedImpl<N>
    extends MetricConfigFluentImpl<SignalfxSpecFluent.MetricsNested<N>>
    implements SignalfxSpecFluent.MetricsNested<N>,
    Nested<N> {
        private final MetricConfigBuilder builder;
        private final int index;

        MetricsNestedImpl(int index, MetricConfig item) {
            this.index = index;
            this.builder = new MetricConfigBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)SignalfxSpecFluentImpl.this.setToMetrics(this.index, this.builder.build());
        }

        @Override
        public N endMetric() {
            return this.and();
        }
    }
}

