/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchSpec;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchSpecFluent;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchSpecFluentImpl;

public class CloudwatchSpecBuilder
extends CloudwatchSpecFluentImpl<CloudwatchSpecBuilder>
implements VisitableBuilder<CloudwatchSpec, CloudwatchSpecBuilder> {
    CloudwatchSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CloudwatchSpecBuilder() {
        this(true);
    }

    public CloudwatchSpecBuilder(Boolean validationEnabled) {
        this(new CloudwatchSpec(), validationEnabled);
    }

    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CloudwatchSpec(), validationEnabled);
    }

    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent, CloudwatchSpec instance) {
        this(fluent, instance, true);
    }

    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent, CloudwatchSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLogGroupName(instance.getLogGroupName());
        fluent.withLogStreamName(instance.getLogStreamName());
        fluent.withLogs(instance.getLogs());
        fluent.withMetricInfo(instance.getMetricInfo());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchSpecBuilder(CloudwatchSpec instance) {
        this(instance, (Boolean)true);
    }

    public CloudwatchSpecBuilder(CloudwatchSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLogGroupName(instance.getLogGroupName());
        this.withLogStreamName(instance.getLogStreamName());
        this.withLogs(instance.getLogs());
        this.withMetricInfo(instance.getMetricInfo());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchSpecBuilder(Validator validator) {
        this(new CloudwatchSpec(), (Boolean)true);
    }

    public CloudwatchSpecBuilder(CloudwatchSpecFluent<?> fluent, CloudwatchSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withLogGroupName(instance.getLogGroupName());
        fluent.withLogStreamName(instance.getLogStreamName());
        fluent.withLogs(instance.getLogs());
        fluent.withMetricInfo(instance.getMetricInfo());
        fluent.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CloudwatchSpecBuilder(CloudwatchSpec instance, Validator validator) {
        this.fluent = this;
        this.withLogGroupName(instance.getLogGroupName());
        this.withLogStreamName(instance.getLogStreamName());
        this.withLogs(instance.getLogs());
        this.withMetricInfo(instance.getMetricInfo());
        this.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CloudwatchSpec build() {
        CloudwatchSpec buildable = new CloudwatchSpec(this.fluent.getLogGroupName(), this.fluent.getLogStreamName(), this.fluent.getLogs(), this.fluent.getMetricInfo(), this.fluent.getNamespace());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchSpecBuilder that = (CloudwatchSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

