/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.cloudwatch;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchList;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchListFluent;
import me.snowdrop.istio.mixer.adapter.cloudwatch.CloudwatchListFluentImpl;

public class CloudwatchListBuilder
extends CloudwatchListFluentImpl<CloudwatchListBuilder>
implements VisitableBuilder<CloudwatchList, CloudwatchListBuilder> {
    CloudwatchListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public CloudwatchListBuilder() {
        this(true);
    }

    public CloudwatchListBuilder(Boolean validationEnabled) {
        this(new CloudwatchList(), validationEnabled);
    }

    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CloudwatchList(), validationEnabled);
    }

    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent, CloudwatchList instance) {
        this(fluent, instance, true);
    }

    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent, CloudwatchList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchListBuilder(CloudwatchList instance) {
        this(instance, (Boolean)true);
    }

    public CloudwatchListBuilder(CloudwatchList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public CloudwatchListBuilder(Validator validator) {
        this(new CloudwatchList(), (Boolean)true);
    }

    public CloudwatchListBuilder(CloudwatchListFluent<?> fluent, CloudwatchList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CloudwatchListBuilder(CloudwatchList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public CloudwatchList build() {
        CloudwatchList buildable = new CloudwatchList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudwatchListBuilder that = (CloudwatchListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

