/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.authentication.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.authentication.v1alpha1.Jwt;
import me.snowdrop.istio.api.authentication.v1alpha1.JwtFluent;
import me.snowdrop.istio.api.authentication.v1alpha1.JwtFluentImpl;

public class JwtBuilder
extends JwtFluentImpl<JwtBuilder>
implements VisitableBuilder<Jwt, JwtBuilder> {
    JwtFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JwtBuilder() {
        this(true);
    }

    public JwtBuilder(Boolean validationEnabled) {
        this(new Jwt(), validationEnabled);
    }

    public JwtBuilder(JwtFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JwtBuilder(JwtFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Jwt(), validationEnabled);
    }

    public JwtBuilder(JwtFluent<?> fluent, Jwt instance) {
        this(fluent, instance, true);
    }

    public JwtBuilder(JwtFluent<?> fluent, Jwt instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAudiences(instance.getAudiences());
        fluent.withIssuer(instance.getIssuer());
        fluent.withJwksUri(instance.getJwksUri());
        fluent.withJwtHeaders(instance.getJwtHeaders());
        fluent.withJwtParams(instance.getJwtParams());
        fluent.withTriggerRules(instance.getTriggerRules());
        this.validationEnabled = validationEnabled;
    }

    public JwtBuilder(Jwt instance) {
        this(instance, (Boolean)true);
    }

    public JwtBuilder(Jwt instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAudiences(instance.getAudiences());
        this.withIssuer(instance.getIssuer());
        this.withJwksUri(instance.getJwksUri());
        this.withJwtHeaders(instance.getJwtHeaders());
        this.withJwtParams(instance.getJwtParams());
        this.withTriggerRules(instance.getTriggerRules());
        this.validationEnabled = validationEnabled;
    }

    public JwtBuilder(Validator validator) {
        this(new Jwt(), (Boolean)true);
    }

    public JwtBuilder(JwtFluent<?> fluent, Jwt instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAudiences(instance.getAudiences());
        fluent.withIssuer(instance.getIssuer());
        fluent.withJwksUri(instance.getJwksUri());
        fluent.withJwtHeaders(instance.getJwtHeaders());
        fluent.withJwtParams(instance.getJwtParams());
        fluent.withTriggerRules(instance.getTriggerRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JwtBuilder(Jwt instance, Validator validator) {
        this.fluent = this;
        this.withAudiences(instance.getAudiences());
        this.withIssuer(instance.getIssuer());
        this.withJwksUri(instance.getJwksUri());
        this.withJwtHeaders(instance.getJwtHeaders());
        this.withJwtParams(instance.getJwtParams());
        this.withTriggerRules(instance.getTriggerRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Jwt build() {
        Jwt buildable = new Jwt(this.fluent.getAudiences(), this.fluent.getIssuer(), this.fluent.getJwksUri(), this.fluent.getJwtHeaders(), this.fluent.getJwtParams(), this.fluent.getTriggerRules());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtBuilder that = (JwtBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

