/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.stackdriver.Trace;
import me.snowdrop.istio.mixer.adapter.stackdriver.TraceFluent;
import me.snowdrop.istio.mixer.adapter.stackdriver.TraceFluentImpl;

public class TraceBuilder
extends TraceFluentImpl<TraceBuilder>
implements VisitableBuilder<Trace, TraceBuilder> {
    TraceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public TraceBuilder() {
        this(true);
    }

    public TraceBuilder(Boolean validationEnabled) {
        this(new Trace(), validationEnabled);
    }

    public TraceBuilder(TraceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TraceBuilder(TraceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Trace(), validationEnabled);
    }

    public TraceBuilder(TraceFluent<?> fluent, Trace instance) {
        this(fluent, instance, true);
    }

    public TraceBuilder(TraceFluent<?> fluent, Trace instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withSampleProbability(instance.getSampleProbability());
        this.validationEnabled = validationEnabled;
    }

    public TraceBuilder(Trace instance) {
        this(instance, (Boolean)true);
    }

    public TraceBuilder(Trace instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withSampleProbability(instance.getSampleProbability());
        this.validationEnabled = validationEnabled;
    }

    public TraceBuilder(Validator validator) {
        this(new Trace(), (Boolean)true);
    }

    public TraceBuilder(TraceFluent<?> fluent, Trace instance, Validator validator) {
        this.fluent = fluent;
        fluent.withSampleProbability(instance.getSampleProbability());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public TraceBuilder(Trace instance, Validator validator) {
        this.fluent = this;
        this.withSampleProbability(instance.getSampleProbability());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Trace build() {
        Trace buildable = new Trace(this.fluent.getSampleProbability());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TraceBuilder that = (TraceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

