/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.solarwinds;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsSpec;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsSpecFluent;
import me.snowdrop.istio.mixer.adapter.solarwinds.SolarwindsSpecFluentImpl;

public class SolarwindsSpecBuilder
extends SolarwindsSpecFluentImpl<SolarwindsSpecBuilder>
implements VisitableBuilder<SolarwindsSpec, SolarwindsSpecBuilder> {
    SolarwindsSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SolarwindsSpecBuilder() {
        this(true);
    }

    public SolarwindsSpecBuilder(Boolean validationEnabled) {
        this(new SolarwindsSpec(), validationEnabled);
    }

    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SolarwindsSpec(), validationEnabled);
    }

    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent, SolarwindsSpec instance) {
        this(fluent, instance, true);
    }

    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent, SolarwindsSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        fluent.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        fluent.withLogs(instance.getLogs());
        fluent.withMetrics(instance.getMetrics());
        fluent.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        fluent.withPapertrailUrl(instance.getPapertrailUrl());
        this.validationEnabled = validationEnabled;
    }

    public SolarwindsSpecBuilder(SolarwindsSpec instance) {
        this(instance, (Boolean)true);
    }

    public SolarwindsSpecBuilder(SolarwindsSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        this.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        this.withLogs(instance.getLogs());
        this.withMetrics(instance.getMetrics());
        this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        this.withPapertrailUrl(instance.getPapertrailUrl());
        this.validationEnabled = validationEnabled;
    }

    public SolarwindsSpecBuilder(Validator validator) {
        this(new SolarwindsSpec(), (Boolean)true);
    }

    public SolarwindsSpecBuilder(SolarwindsSpecFluent<?> fluent, SolarwindsSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        fluent.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        fluent.withLogs(instance.getLogs());
        fluent.withMetrics(instance.getMetrics());
        fluent.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        fluent.withPapertrailUrl(instance.getPapertrailUrl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SolarwindsSpecBuilder(SolarwindsSpec instance, Validator validator) {
        this.fluent = this;
        this.withAppopticsAccessToken(instance.getAppopticsAccessToken());
        this.withAppopticsBatchSize(instance.getAppopticsBatchSize());
        this.withLogs(instance.getLogs());
        this.withMetrics(instance.getMetrics());
        this.withPapertrailLocalRetentionDuration(instance.getPapertrailLocalRetentionDuration());
        this.withPapertrailUrl(instance.getPapertrailUrl());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SolarwindsSpec build() {
        SolarwindsSpec buildable = new SolarwindsSpec(this.fluent.getAppopticsAccessToken(), this.fluent.getAppopticsBatchSize(), this.fluent.getLogs(), this.fluent.getMetrics(), this.fluent.getPapertrailLocalRetentionDuration(), this.fluent.getPapertrailUrl());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SolarwindsSpecBuilder that = (SolarwindsSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

