/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.Seconds;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class Duration
implements Serializable {
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private Integer nanos;
    private Long seconds;
    private static final PeriodFormatter FORMATTER = new PeriodFormatterBuilder().printZeroNever().appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").appendMillis().appendSuffix("ms").toFormatter();

    public Duration() {
    }

    public Duration(Integer nanos, Long seconds) {
        this.nanos = nanos;
        this.seconds = seconds;
    }

    public Integer getNanos() {
        return this.nanos;
    }

    public Long getSeconds() {
        return this.seconds;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "Duration(additionalProperties=" + this.getAdditionalProperties() + ", nanos=" + this.getNanos() + ", seconds=" + this.getSeconds() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration other = (Duration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        if (this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties)) {
            return false;
        }
        Integer this$nanos = this.getNanos();
        Integer other$nanos = other.getNanos();
        if (this$nanos == null ? other$nanos != null : !((Object)this$nanos).equals(other$nanos)) {
            return false;
        }
        Long this$seconds = this.getSeconds();
        Long other$seconds = other.getSeconds();
        return !(this$seconds == null ? other$seconds != null : !((Object)this$seconds).equals(other$seconds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Duration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        Integer $nanos = this.getNanos();
        result = result * 59 + ($nanos == null ? 43 : ((Object)$nanos).hashCode());
        Long $seconds = this.getSeconds();
        result = result * 59 + ($seconds == null ? 43 : ((Object)$seconds).hashCode());
        return result;
    }

    public static class Serializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(FORMATTER.print((ReadablePeriod)Seconds.seconds((int)value.seconds.intValue())));
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            Period period = FORMATTER.parsePeriod(node.asText());
            return new Duration(0, Long.valueOf(period.toStandardSeconds().getSeconds()));
        }
    }
}

