/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.opa;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.adapter.opa.OpaSpec;
import me.snowdrop.istio.adapter.opa.OpaSpecFluent;

public class OpaSpecFluentImpl<A extends OpaSpecFluent<A>>
extends BaseFluent<A>
implements OpaSpecFluent<A> {
    private String checkMethod;
    private Boolean failClose;
    private List<String> policy;

    public OpaSpecFluentImpl() {
    }

    public OpaSpecFluentImpl(OpaSpec instance) {
        this.withCheckMethod(instance.getCheckMethod());
        this.withFailClose(instance.getFailClose());
        this.withPolicy(instance.getPolicy());
    }

    @Override
    public String getCheckMethod() {
        return this.checkMethod;
    }

    @Override
    public A withCheckMethod(String checkMethod) {
        this.checkMethod = checkMethod;
        return (A)this;
    }

    @Override
    public Boolean hasCheckMethod() {
        return this.checkMethod != null;
    }

    @Override
    public Boolean isFailClose() {
        return this.failClose;
    }

    @Override
    public A withFailClose(Boolean failClose) {
        this.failClose = failClose;
        return (A)this;
    }

    @Override
    public Boolean hasFailClose() {
        return this.failClose != null;
    }

    @Override
    public A withNewFailClose(String arg1) {
        return this.withFailClose(new Boolean(arg1));
    }

    @Override
    public A withNewFailClose(boolean arg1) {
        return this.withFailClose(new Boolean(arg1));
    }

    @Override
    public A addToPolicy(int index, String item) {
        if (this.policy == null) {
            this.policy = new ArrayList<String>();
        }
        this.policy.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPolicy(int index, String item) {
        if (this.policy == null) {
            this.policy = new ArrayList<String>();
        }
        this.policy.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPolicy(String ... items) {
        if (this.policy == null) {
            this.policy = new ArrayList<String>();
        }
        for (String item : items) {
            this.policy.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicy(Collection<String> items) {
        if (this.policy == null) {
            this.policy = new ArrayList<String>();
        }
        for (String item : items) {
            this.policy.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicy(String ... items) {
        for (String item : items) {
            if (this.policy == null) continue;
            this.policy.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicy(Collection<String> items) {
        for (String item : items) {
            if (this.policy == null) continue;
            this.policy.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPolicy() {
        return this.policy;
    }

    @Override
    public String getPolicy(int index) {
        return this.policy.get(index);
    }

    @Override
    public String getFirstPolicy() {
        return this.policy.get(0);
    }

    @Override
    public String getLastPolicy() {
        return this.policy.get(this.policy.size() - 1);
    }

    @Override
    public String getMatchingPolicy(Predicate<String> predicate) {
        for (String item : this.policy) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withPolicy(List<String> policy) {
        if (this.policy != null) {
            this._visitables.removeAll(this.policy);
        }
        if (policy != null) {
            this.policy = new ArrayList<String>();
            for (String item : policy) {
                this.addToPolicy(item);
            }
        } else {
            this.policy = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicy(String ... policy) {
        if (this.policy != null) {
            this.policy.clear();
        }
        if (policy != null) {
            for (String item : policy) {
                this.addToPolicy(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicy() {
        return this.policy != null && !this.policy.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpaSpecFluentImpl that = (OpaSpecFluentImpl)o;
        if (this.checkMethod != null ? !this.checkMethod.equals(that.checkMethod) : that.checkMethod != null) {
            return false;
        }
        if (this.failClose != null ? !this.failClose.equals(that.failClose) : that.failClose != null) {
            return false;
        }
        return !(this.policy != null ? !this.policy.equals(that.policy) : that.policy != null);
    }
}

