/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.list;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.adapter.list.BaseKubernetesList;
import me.snowdrop.istio.adapter.list.BaseKubernetesListFluent;
import me.snowdrop.istio.adapter.list.ListEntryType;

public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>>
extends BaseFluent<A>
implements BaseKubernetesListFluent<A> {
    private Boolean blacklist;
    private Long cachingInterval;
    private Integer cachingUseCount;
    private ListEntryType entryType;
    private List<String> overrides;
    private String providerUrl;
    private Long refreshInterval;
    private Long ttl;

    public BaseKubernetesListFluentImpl() {
    }

    public BaseKubernetesListFluentImpl(BaseKubernetesList instance) {
        this.withBlacklist(instance.getBlacklist());
        this.withCachingInterval(instance.getCachingInterval());
        this.withCachingUseCount(instance.getCachingUseCount());
        this.withEntryType(instance.getEntryType());
        this.withOverrides(instance.getOverrides());
        this.withProviderUrl(instance.getProviderUrl());
        this.withRefreshInterval(instance.getRefreshInterval());
        this.withTtl(instance.getTtl());
    }

    @Override
    public Boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public A withBlacklist(Boolean blacklist) {
        this.blacklist = blacklist;
        return (A)this;
    }

    @Override
    public Boolean hasBlacklist() {
        return this.blacklist != null;
    }

    @Override
    public A withNewBlacklist(String arg1) {
        return this.withBlacklist(new Boolean(arg1));
    }

    @Override
    public A withNewBlacklist(boolean arg1) {
        return this.withBlacklist(new Boolean(arg1));
    }

    @Override
    public Long getCachingInterval() {
        return this.cachingInterval;
    }

    @Override
    public A withCachingInterval(Long cachingInterval) {
        this.cachingInterval = cachingInterval;
        return (A)this;
    }

    @Override
    public Boolean hasCachingInterval() {
        return this.cachingInterval != null;
    }

    @Override
    public A withNewCachingInterval(String arg1) {
        return this.withCachingInterval(new Long(arg1));
    }

    @Override
    public A withNewCachingInterval(long arg1) {
        return this.withCachingInterval(new Long(arg1));
    }

    @Override
    public Integer getCachingUseCount() {
        return this.cachingUseCount;
    }

    @Override
    public A withCachingUseCount(Integer cachingUseCount) {
        this.cachingUseCount = cachingUseCount;
        return (A)this;
    }

    @Override
    public Boolean hasCachingUseCount() {
        return this.cachingUseCount != null;
    }

    @Override
    public A withNewCachingUseCount(String arg1) {
        return this.withCachingUseCount(new Integer(arg1));
    }

    @Override
    public A withNewCachingUseCount(int arg1) {
        return this.withCachingUseCount(new Integer(arg1));
    }

    @Override
    public ListEntryType getEntryType() {
        return this.entryType;
    }

    @Override
    public A withEntryType(ListEntryType entryType) {
        this.entryType = entryType;
        return (A)this;
    }

    @Override
    public Boolean hasEntryType() {
        return this.entryType != null;
    }

    @Override
    public A addToOverrides(int index, String item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<String>();
        }
        this.overrides.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOverrides(int index, String item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<String>();
        }
        this.overrides.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOverrides(String ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<String>();
        }
        for (String item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOverrides(Collection<String> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<String>();
        }
        for (String item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverrides(String ... items) {
        for (String item : items) {
            if (this.overrides == null) continue;
            this.overrides.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOverrides(Collection<String> items) {
        for (String item : items) {
            if (this.overrides == null) continue;
            this.overrides.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOverrides() {
        return this.overrides;
    }

    @Override
    public String getOverride(int index) {
        return this.overrides.get(index);
    }

    @Override
    public String getFirstOverride() {
        return this.overrides.get(0);
    }

    @Override
    public String getLastOverride() {
        return this.overrides.get(this.overrides.size() - 1);
    }

    @Override
    public String getMatchingOverride(Predicate<String> predicate) {
        for (String item : this.overrides) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withOverrides(List<String> overrides) {
        if (this.overrides != null) {
            this._visitables.removeAll(this.overrides);
        }
        if (overrides != null) {
            this.overrides = new ArrayList<String>();
            for (String item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    @Override
    public A withOverrides(String ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
        }
        if (overrides != null) {
            for (String item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    @Override
    public String getProviderUrl() {
        return this.providerUrl;
    }

    @Override
    public A withProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
        return (A)this;
    }

    @Override
    public Boolean hasProviderUrl() {
        return this.providerUrl != null;
    }

    @Override
    public Long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public A withRefreshInterval(Long refreshInterval) {
        this.refreshInterval = refreshInterval;
        return (A)this;
    }

    @Override
    public Boolean hasRefreshInterval() {
        return this.refreshInterval != null;
    }

    @Override
    public A withNewRefreshInterval(String arg1) {
        return this.withRefreshInterval(new Long(arg1));
    }

    @Override
    public A withNewRefreshInterval(long arg1) {
        return this.withRefreshInterval(new Long(arg1));
    }

    @Override
    public Long getTtl() {
        return this.ttl;
    }

    @Override
    public A withTtl(Long ttl) {
        this.ttl = ttl;
        return (A)this;
    }

    @Override
    public Boolean hasTtl() {
        return this.ttl != null;
    }

    @Override
    public A withNewTtl(String arg1) {
        return this.withTtl(new Long(arg1));
    }

    @Override
    public A withNewTtl(long arg1) {
        return this.withTtl(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl)o;
        if (this.blacklist != null ? !this.blacklist.equals(that.blacklist) : that.blacklist != null) {
            return false;
        }
        if (this.cachingInterval != null ? !this.cachingInterval.equals(that.cachingInterval) : that.cachingInterval != null) {
            return false;
        }
        if (this.cachingUseCount != null ? !this.cachingUseCount.equals(that.cachingUseCount) : that.cachingUseCount != null) {
            return false;
        }
        if (this.entryType != null ? !this.entryType.equals((Object)that.entryType) : that.entryType != null) {
            return false;
        }
        if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) {
            return false;
        }
        if (this.providerUrl != null ? !this.providerUrl.equals(that.providerUrl) : that.providerUrl != null) {
            return false;
        }
        if (this.refreshInterval != null ? !this.refreshInterval.equals(that.refreshInterval) : that.refreshInterval != null) {
            return false;
        }
        return !(this.ttl != null ? !this.ttl.equals(that.ttl) : that.ttl != null);
    }
}

