/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.adapter.fluentd.FluentdSpec;
import me.snowdrop.istio.adapter.fluentd.FluentdSpecFluent;
import me.snowdrop.istio.adapter.fluentd.FluentdSpecFluentImpl;

public class FluentdSpecBuilder
extends FluentdSpecFluentImpl<FluentdSpecBuilder>
implements VisitableBuilder<FluentdSpec, FluentdSpecBuilder> {
    FluentdSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public FluentdSpecBuilder() {
        this(true);
    }

    public FluentdSpecBuilder(Boolean validationEnabled) {
        this(new FluentdSpec(), validationEnabled);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new FluentdSpec(), validationEnabled);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, FluentdSpec instance) {
        this(fluent, instance, true);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, FluentdSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withIntegerDuration(instance.getIntegerDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdSpecBuilder(FluentdSpec instance) {
        this(instance, (Boolean)true);
    }

    public FluentdSpecBuilder(FluentdSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withIntegerDuration(instance.getIntegerDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdSpecBuilder(Validator validator) {
        this(new FluentdSpec(), (Boolean)true);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, FluentdSpec instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withIntegerDuration(instance.getIntegerDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public FluentdSpecBuilder(FluentdSpec instance, Validator validator) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withIntegerDuration(instance.getIntegerDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public FluentdSpec build() {
        FluentdSpec buildable = new FluentdSpec(this.fluent.getAddress(), this.fluent.isIntegerDuration());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FluentdSpecBuilder that = (FluentdSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

