/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client;

import io.fabric8.kubernetes.api.model.v3_1.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v3_1.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.model.DoneableIstioResource;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.client.Adapter;

public class KubernetesAdapter
implements Adapter {
    private KubernetesClient client;

    public KubernetesAdapter(KubernetesClient kubernetesClient) {
        this.client = kubernetesClient;
    }

    @Override
    public List<IstioResource> createCustomResources(IstioResource ... resources) {
        if (resources != null) {
            ArrayList<IstioResource> results = new ArrayList<IstioResource>(resources.length);
            for (IstioResource resource : resources) {
                CustomResourceDefinition customResourceDefinition = this.getCustomResourceDefinition(resource);
                IstioResource result = (IstioResource)((NonNamespaceOperation)this.client.customResources(customResourceDefinition, IstioResource.class, KubernetesResourceList.class, DoneableIstioResource.class).inNamespace(this.client.getNamespace())).create((Object[])new IstioResource[]{resource});
                results.add(result);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean deleteCustomResources(IstioResource resource) {
        if (resource != null) {
            CustomResourceDefinition customResourceDefinition = this.getCustomResourceDefinition(resource);
            return (Boolean)((NonNamespaceOperation)this.client.customResources(customResourceDefinition, IstioResource.class, KubernetesResourceList.class, DoneableIstioResource.class).inNamespace(this.client.getNamespace())).delete((Object[])new IstioResource[]{resource});
        }
        return false;
    }

    private CustomResourceDefinition getCustomResourceDefinition(IstioResource resource) {
        String crdName = IstioSpecRegistry.getCRDNameFor(resource.getKind());
        CustomResourceDefinition customResourceDefinition = (CustomResourceDefinition)((Resource)this.client.customResourceDefinitions().withName(crdName)).get();
        if (customResourceDefinition == null) {
            throw new IllegalArgumentException(String.format("Custom Resource Definition %s is not found in cluster %s", crdName, this.client.getMasterUrl()));
        }
        return customResourceDefinition;
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.client;
    }
}

