/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import me.snowdrop.istio.api.builder.ValidationUtils;
import me.snowdrop.istio.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.routing.RouteRule;
import me.snowdrop.istio.api.model.v1.routing.RouteRuleFluent;
import me.snowdrop.istio.api.model.v1.routing.RouteRuleFluentImpl;

public class RouteRuleBuilder
extends RouteRuleFluentImpl<RouteRuleBuilder>
implements VisitableBuilder<RouteRule, RouteRuleBuilder> {
    RouteRuleFluent<?> fluent;
    Boolean validationEnabled;

    public RouteRuleBuilder() {
        this(true);
    }

    public RouteRuleBuilder(Boolean validationEnabled) {
        this(new RouteRule(), validationEnabled);
    }

    public RouteRuleBuilder(RouteRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteRuleBuilder(RouteRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteRule(), validationEnabled);
    }

    public RouteRuleBuilder(RouteRuleFluent<?> fluent, RouteRule instance) {
        this(fluent, instance, true);
    }

    public RouteRuleBuilder(RouteRuleFluent<?> fluent, RouteRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAppendHeaders(instance.getAppendHeaders());
        fluent.withCorsPolicy(instance.getCorsPolicy());
        fluent.withDestination(instance.getDestination());
        fluent.withHttpFault(instance.getHttpFault());
        fluent.withHttpReqRetries(instance.getHttpReqRetries());
        fluent.withHttpReqTimeout(instance.getHttpReqTimeout());
        fluent.withL4Fault(instance.getL4Fault());
        fluent.withMatch(instance.getMatch());
        fluent.withMirror(instance.getMirror());
        fluent.withPrecedence(instance.getPrecedence());
        fluent.withRedirect(instance.getRedirect());
        fluent.withRewrite(instance.getRewrite());
        fluent.withRoute(instance.getRoute());
        fluent.withWebsocketUpgrade(instance.getWebsocketUpgrade());
        this.validationEnabled = validationEnabled;
    }

    public RouteRuleBuilder(RouteRule instance) {
        this(instance, (Boolean)true);
    }

    public RouteRuleBuilder(RouteRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAppendHeaders(instance.getAppendHeaders());
        this.withCorsPolicy(instance.getCorsPolicy());
        this.withDestination(instance.getDestination());
        this.withHttpFault(instance.getHttpFault());
        this.withHttpReqRetries(instance.getHttpReqRetries());
        this.withHttpReqTimeout(instance.getHttpReqTimeout());
        this.withL4Fault(instance.getL4Fault());
        this.withMatch(instance.getMatch());
        this.withMirror(instance.getMirror());
        this.withPrecedence(instance.getPrecedence());
        this.withRedirect(instance.getRedirect());
        this.withRewrite(instance.getRewrite());
        this.withRoute(instance.getRoute());
        this.withWebsocketUpgrade(instance.getWebsocketUpgrade());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RouteRule build() {
        RouteRule buildable = new RouteRule(this.fluent.getAppendHeaders(), this.fluent.getCorsPolicy(), this.fluent.getDestination(), this.fluent.getHttpFault(), this.fluent.getHttpReqRetries(), this.fluent.getHttpReqTimeout(), this.fluent.getL4Fault(), this.fluent.getMatch(), this.fluent.getMirror(), this.fluent.getPrecedence(), this.fluent.getRedirect(), this.fluent.getRewrite(), this.fluent.getRoute(), this.fluent.isWebsocketUpgrade());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteRuleBuilder that = (RouteRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

