/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import java.util.LinkedHashMap;
import java.util.Map;
import me.snowdrop.istio.api.builder.BaseFluent;
import me.snowdrop.istio.api.model.v1.routing.IstioService;
import me.snowdrop.istio.api.model.v1.routing.IstioServiceFluent;

public class IstioServiceFluentImpl<A extends IstioServiceFluent<A>>
extends BaseFluent<A>
implements IstioServiceFluent<A> {
    private String domain;
    private Map<String, String> labels;
    private String name;
    private String namespace;
    private String service;

    public IstioServiceFluentImpl() {
    }

    public IstioServiceFluentImpl(IstioService instance) {
        this.withDomain(instance.getDomain());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withService(instance.getService());
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public A withService(String service) {
        this.service = service;
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioServiceFluentImpl that = (IstioServiceFluentImpl)o;
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.service != null ? !this.service.equals(that.service) : that.service != null);
    }
}

