/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import me.snowdrop.istio.api.builder.ValidationUtils;
import me.snowdrop.istio.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.routing.IngressRule;
import me.snowdrop.istio.api.model.v1.routing.IngressRuleFluent;
import me.snowdrop.istio.api.model.v1.routing.IngressRuleFluentImpl;

public class IngressRuleBuilder
extends IngressRuleFluentImpl<IngressRuleBuilder>
implements VisitableBuilder<IngressRule, IngressRuleBuilder> {
    IngressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public IngressRuleBuilder() {
        this(true);
    }

    public IngressRuleBuilder(Boolean validationEnabled) {
        this(new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressRule(), validationEnabled);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance) {
        this(fluent, instance, true);
    }

    public IngressRuleBuilder(IngressRuleFluent<?> fluent, IngressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestinationServicePort(instance.getDestinationServicePort());
        fluent.withDestination(instance.getDestination());
        fluent.withMatch(instance.getMatch());
        fluent.withPort(instance.getPort());
        fluent.withPrecedence(instance.getPrecedence());
        fluent.withTlsSecret(instance.getTlsSecret());
        this.validationEnabled = validationEnabled;
    }

    public IngressRuleBuilder(IngressRule instance) {
        this(instance, (Boolean)true);
    }

    public IngressRuleBuilder(IngressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestinationServicePort(instance.getDestinationServicePort());
        this.withDestination(instance.getDestination());
        this.withMatch(instance.getMatch());
        this.withPort(instance.getPort());
        this.withPrecedence(instance.getPrecedence());
        this.withTlsSecret(instance.getTlsSecret());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressRule build() {
        IngressRule buildable = new IngressRule(this.fluent.getDestinationServicePort(), this.fluent.getDestination(), this.fluent.getMatch(), this.fluent.getPort(), this.fluent.getPrecedence(), this.fluent.getTlsSecret());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleBuilder that = (IngressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

