/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.builder.BaseFluent;
import me.snowdrop.istio.api.builder.Nested;
import me.snowdrop.istio.api.builder.Predicate;
import me.snowdrop.istio.api.model.v1.routing.EgressRule;
import me.snowdrop.istio.api.model.v1.routing.EgressRuleFluent;
import me.snowdrop.istio.api.model.v1.routing.IstioService;
import me.snowdrop.istio.api.model.v1.routing.IstioServiceBuilder;
import me.snowdrop.istio.api.model.v1.routing.IstioServiceFluentImpl;
import me.snowdrop.istio.api.model.v1.routing.Port;
import me.snowdrop.istio.api.model.v1.routing.PortBuilder;
import me.snowdrop.istio.api.model.v1.routing.PortFluentImpl;

public class EgressRuleFluentImpl<A extends EgressRuleFluent<A>>
extends BaseFluent<A>
implements EgressRuleFluent<A> {
    private IstioServiceBuilder destination;
    private List<PortBuilder> ports;
    private Boolean useEgressProxy;

    public EgressRuleFluentImpl() {
    }

    public EgressRuleFluentImpl(EgressRule instance) {
        this.withDestination(instance.getDestination());
        this.withPorts(instance.getPorts());
        this.withUseEgressProxy(instance.getUseEgressProxy());
    }

    @Override
    @Deprecated
    public IstioService getDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public IstioService buildDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public A withDestination(IstioService destination) {
        this._visitables.remove(this.destination);
        if (destination != null) {
            this.destination = new IstioServiceBuilder(destination);
            this._visitables.add(this.destination);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDestination() {
        return this.destination != null;
    }

    @Override
    public EgressRuleFluent.DestinationNested<A> withNewDestination() {
        return new DestinationNestedImpl();
    }

    @Override
    public EgressRuleFluent.DestinationNested<A> withNewDestinationLike(IstioService item) {
        return new DestinationNestedImpl(item);
    }

    @Override
    public EgressRuleFluent.DestinationNested<A> editDestination() {
        return this.withNewDestinationLike(this.getDestination());
    }

    @Override
    public EgressRuleFluent.DestinationNested<A> editOrNewDestination() {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : new IstioServiceBuilder().build());
    }

    @Override
    public EgressRuleFluent.DestinationNested<A> editOrNewDestinationLike(IstioService item) {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : item);
    }

    @Override
    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Port> getPorts() {
        return EgressRuleFluentImpl.build(this.ports);
    }

    @Override
    public List<Port> buildPorts() {
        return EgressRuleFluentImpl.build(this.ports);
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<Port> ports) {
        if (this.ports != null) {
            this._visitables.removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<PortBuilder>();
            for (Port item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(Port ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(Integer port, String protocol) {
        return this.addToPorts(new Port(port, protocol));
    }

    @Override
    public EgressRuleFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EgressRuleFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public EgressRuleFluent.PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public EgressRuleFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EgressRuleFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public EgressRuleFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EgressRuleFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public Boolean isUseEgressProxy() {
        return this.useEgressProxy;
    }

    @Override
    public A withUseEgressProxy(Boolean useEgressProxy) {
        this.useEgressProxy = useEgressProxy;
        return (A)this;
    }

    @Override
    public Boolean hasUseEgressProxy() {
        return this.useEgressProxy != null;
    }

    @Override
    public A withNewUseEgressProxy(boolean arg1) {
        return this.withUseEgressProxy(new Boolean(arg1));
    }

    @Override
    public A withNewUseEgressProxy(String arg1) {
        return this.withUseEgressProxy(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressRuleFluentImpl that = (EgressRuleFluentImpl)o;
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.useEgressProxy != null ? !this.useEgressProxy.equals(that.useEgressProxy) : that.useEgressProxy != null);
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<EgressRuleFluent.PortsNested<N>>
    implements EgressRuleFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressRuleFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class DestinationNestedImpl<N>
    extends IstioServiceFluentImpl<EgressRuleFluent.DestinationNested<N>>
    implements EgressRuleFluent.DestinationNested<N>,
    Nested<N> {
        private final IstioServiceBuilder builder;

        DestinationNestedImpl(IstioService item) {
            this.builder = new IstioServiceBuilder(this, item);
        }

        DestinationNestedImpl() {
            this.builder = new IstioServiceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressRuleFluentImpl.this.withDestination(this.builder.build());
        }

        @Override
        public N endDestination() {
            return this.and();
        }
    }
}

