/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.mixer.config;

import me.snowdrop.istio.api.builder.ValidationUtils;
import me.snowdrop.istio.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.mixer.config.Instance;
import me.snowdrop.istio.api.model.v1.mixer.config.InstanceFluent;
import me.snowdrop.istio.api.model.v1.mixer.config.InstanceFluentImpl;

public class InstanceBuilder
extends InstanceFluentImpl<InstanceBuilder>
implements VisitableBuilder<Instance, InstanceBuilder> {
    InstanceFluent<?> fluent;
    Boolean validationEnabled;

    public InstanceBuilder() {
        this(true);
    }

    public InstanceBuilder(Boolean validationEnabled) {
        this(new Instance(), validationEnabled);
    }

    public InstanceBuilder(InstanceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InstanceBuilder(InstanceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Instance(), validationEnabled);
    }

    public InstanceBuilder(InstanceFluent<?> fluent, Instance instance) {
        this(fluent, instance, true);
    }

    public InstanceBuilder(InstanceFluent<?> fluent, Instance instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withParams(instance.getParams());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public InstanceBuilder(Instance instance) {
        this(instance, (Boolean)true);
    }

    public InstanceBuilder(Instance instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withParams(instance.getParams());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Instance build() {
        Instance buildable = new Instance(this.fluent.getName(), this.fluent.getParams(), this.fluent.getTemplate());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InstanceBuilder that = (InstanceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

