/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.broker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.builder.BaseFluent;
import me.snowdrop.istio.api.builder.Nested;
import me.snowdrop.istio.api.builder.Predicate;
import me.snowdrop.istio.api.model.v1.broker.CatalogPlan;
import me.snowdrop.istio.api.model.v1.broker.CatalogPlanBuilder;
import me.snowdrop.istio.api.model.v1.broker.CatalogPlanFluentImpl;
import me.snowdrop.istio.api.model.v1.broker.ServicePlan;
import me.snowdrop.istio.api.model.v1.broker.ServicePlanFluent;

public class ServicePlanFluentImpl<A extends ServicePlanFluent<A>>
extends BaseFluent<A>
implements ServicePlanFluent<A> {
    private CatalogPlanBuilder plan;
    private List<String> services;

    public ServicePlanFluentImpl() {
    }

    public ServicePlanFluentImpl(ServicePlan instance) {
        this.withPlan(instance.getPlan());
        this.withServices(instance.getServices());
    }

    @Override
    @Deprecated
    public CatalogPlan getPlan() {
        return this.plan != null ? this.plan.build() : null;
    }

    @Override
    public CatalogPlan buildPlan() {
        return this.plan != null ? this.plan.build() : null;
    }

    @Override
    public A withPlan(CatalogPlan plan) {
        this._visitables.remove(this.plan);
        if (plan != null) {
            this.plan = new CatalogPlanBuilder(plan);
            this._visitables.add(this.plan);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlan() {
        return this.plan != null;
    }

    @Override
    public A withNewPlan(String description, String id, String name) {
        return this.withPlan(new CatalogPlan(description, id, name));
    }

    @Override
    public ServicePlanFluent.PlanNested<A> withNewPlan() {
        return new PlanNestedImpl();
    }

    @Override
    public ServicePlanFluent.PlanNested<A> withNewPlanLike(CatalogPlan item) {
        return new PlanNestedImpl(item);
    }

    @Override
    public ServicePlanFluent.PlanNested<A> editPlan() {
        return this.withNewPlanLike(this.getPlan());
    }

    @Override
    public ServicePlanFluent.PlanNested<A> editOrNewPlan() {
        return this.withNewPlanLike(this.getPlan() != null ? this.getPlan() : new CatalogPlanBuilder().build());
    }

    @Override
    public ServicePlanFluent.PlanNested<A> editOrNewPlanLike(CatalogPlan item) {
        return this.withNewPlanLike(this.getPlan() != null ? this.getPlan() : item);
    }

    @Override
    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServices(int index, String item) {
        this.services.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServices(String ... items) {
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<String> items) {
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(String ... items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<String> items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public String getService(int index) {
        return this.services.get(index);
    }

    @Override
    public String getFirstService() {
        return this.services.get(0);
    }

    @Override
    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    @Override
    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withServices(List<String> services) {
        if (this.services != null) {
            this._visitables.removeAll(this.services);
        }
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)this;
    }

    @Override
    public A withServices(String ... services) {
        this.services.clear();
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePlanFluentImpl that = (ServicePlanFluentImpl)o;
        if (this.plan != null ? !this.plan.equals(that.plan) : that.plan != null) {
            return false;
        }
        return !(this.services != null ? !this.services.equals(that.services) : that.services != null);
    }

    public class PlanNestedImpl<N>
    extends CatalogPlanFluentImpl<ServicePlanFluent.PlanNested<N>>
    implements ServicePlanFluent.PlanNested<N>,
    Nested<N> {
        private final CatalogPlanBuilder builder;

        PlanNestedImpl(CatalogPlan item) {
            this.builder = new CatalogPlanBuilder(this, item);
        }

        PlanNestedImpl() {
            this.builder = new CatalogPlanBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicePlanFluentImpl.this.withPlan(this.builder.build());
        }

        @Override
        public N endPlan() {
            return this.and();
        }
    }
}

