/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.broker;

import me.snowdrop.istio.api.builder.ValidationUtils;
import me.snowdrop.istio.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.broker.ServicePlan;
import me.snowdrop.istio.api.model.v1.broker.ServicePlanFluent;
import me.snowdrop.istio.api.model.v1.broker.ServicePlanFluentImpl;

public class ServicePlanBuilder
extends ServicePlanFluentImpl<ServicePlanBuilder>
implements VisitableBuilder<ServicePlan, ServicePlanBuilder> {
    ServicePlanFluent<?> fluent;
    Boolean validationEnabled;

    public ServicePlanBuilder() {
        this(true);
    }

    public ServicePlanBuilder(Boolean validationEnabled) {
        this(new ServicePlan(), validationEnabled);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServicePlan(), validationEnabled);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, ServicePlan instance) {
        this(fluent, instance, true);
    }

    public ServicePlanBuilder(ServicePlanFluent<?> fluent, ServicePlan instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPlan(instance.getPlan());
        fluent.withServices(instance.getServices());
        this.validationEnabled = validationEnabled;
    }

    public ServicePlanBuilder(ServicePlan instance) {
        this(instance, (Boolean)true);
    }

    public ServicePlanBuilder(ServicePlan instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPlan(instance.getPlan());
        this.withServices(instance.getServices());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServicePlan build() {
        ServicePlan buildable = new ServicePlan(this.fluent.getPlan(), this.fluent.getServices());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServicePlanBuilder that = (ServicePlanBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

