/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.broker;

import me.snowdrop.istio.api.builder.ValidationUtils;
import me.snowdrop.istio.api.builder.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.broker.CatalogEntry;
import me.snowdrop.istio.api.model.v1.broker.CatalogEntryFluent;
import me.snowdrop.istio.api.model.v1.broker.CatalogEntryFluentImpl;

public class CatalogEntryBuilder
extends CatalogEntryFluentImpl<CatalogEntryBuilder>
implements VisitableBuilder<CatalogEntry, CatalogEntryBuilder> {
    CatalogEntryFluent<?> fluent;
    Boolean validationEnabled;

    public CatalogEntryBuilder() {
        this(true);
    }

    public CatalogEntryBuilder(Boolean validationEnabled) {
        this(new CatalogEntry(), validationEnabled);
    }

    public CatalogEntryBuilder(CatalogEntryFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CatalogEntryBuilder(CatalogEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CatalogEntry(), validationEnabled);
    }

    public CatalogEntryBuilder(CatalogEntryFluent<?> fluent, CatalogEntry instance) {
        this(fluent, instance, true);
    }

    public CatalogEntryBuilder(CatalogEntryFluent<?> fluent, CatalogEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withId(instance.getId());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public CatalogEntryBuilder(CatalogEntry instance) {
        this(instance, (Boolean)true);
    }

    public CatalogEntryBuilder(CatalogEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withId(instance.getId());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CatalogEntry build() {
        CatalogEntry buildable = new CatalogEntry(this.fluent.getDescription(), this.fluent.getId(), this.fluent.getName());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogEntryBuilder that = (CatalogEntryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

