/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.snowdrop.istio.api.model.IstioSpec;

public class IstioSpecRegistry {
    private static final String ISTIO_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.";
    private static final String ISTIO_VERSION = "v1.";
    private static final String ISTIO_MIXER_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.mixer.";
    private static final String ISTIO_MIXER_TEMPLATE_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.mixer.template.";
    private static final String ISTIO_ROUTING_PACKAGE_PREFIX = "me.snowdrop.istio.api.model.v1.routing.";
    private static final Map<String, Class<? extends IstioSpec>> KIND_TO_TYPE = new HashMap<String, Class<? extends IstioSpec>>();
    private static final Map<String, String> KIND_TO_CLASSNAME = new HashMap<String, String>();
    private static final String DESTINATION_POLICY_CRD_NAME = "destinationpolicies.config.istio.io";
    private static final String EGRESS_RULE_CRD_NAME = "egressrules.config.istio.io";
    private static final String ROUTE_RULE_CRD_NAME = "routerules.config.istio.io";
    private static final Map<String, String> KIND_TO_CRD = new ConcurrentHashMap<String, String>();

    public static Class<? extends IstioSpec> resolveIstioSpecForKind(String name) {
        String className;
        Class<? extends IstioSpec> result = KIND_TO_TYPE.get(name);
        if (result == null && (className = KIND_TO_CLASSNAME.get(name)) != null) {
            result = IstioSpecRegistry.loadClassIfExists(className);
            KIND_TO_TYPE.put(name, result);
        }
        return result;
    }

    public static String getKindFor(Class<? extends IstioSpec> spec) {
        try {
            return spec.newInstance().getKind();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isIstioSpec(String simpleClassName) {
        return KIND_TO_CLASSNAME.containsKey(simpleClassName);
    }

    public static String getCRDNameFor(String kind) {
        return KIND_TO_CRD.get(kind);
    }

    private static Class<? extends IstioSpec> loadClassIfExists(String className) {
        try {
            Class<?> loaded = IstioSpecRegistry.class.getClassLoader().loadClass(className);
            if (IstioSpec.class.isAssignableFrom(loaded)) {
                return loaded.asSubclass(IstioSpec.class);
            }
            throw new IllegalArgumentException(String.format("%s is not an implementation of %s", className, IstioSpec.class.getSimpleName()));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format("Cannot load class: %s", className), t);
        }
    }

    static {
        KIND_TO_CLASSNAME.put("RouteRule", "me.snowdrop.istio.api.model.v1.routing.RouteRule");
        KIND_TO_CLASSNAME.put("DestinationPolicy", "me.snowdrop.istio.api.model.v1.routing.DestinationPolicy");
        KIND_TO_CLASSNAME.put("EgressRule", "me.snowdrop.istio.api.model.v1.routing.EgressRule");
        KIND_TO_CLASSNAME.put("checknothing", "me.snowdrop.istio.api.model.v1.mixer.template.CheckNothing");
        KIND_TO_CLASSNAME.put("listentry", "me.snowdrop.istio.api.model.v1.mixer.template.ListEntry");
        KIND_TO_CLASSNAME.put("logentry", "me.snowdrop.istio.api.model.v1.mixer.template.LogEntry");
        KIND_TO_CLASSNAME.put("metric", "me.snowdrop.istio.api.model.v1.mixer.template.Metric");
        KIND_TO_CLASSNAME.put("quota", "me.snowdrop.istio.api.model.v1.mixer.template.Quota");
        KIND_TO_CLASSNAME.put("reportnothing", "me.snowdrop.istio.api.model.v1.mixer.template.ReportNothing");
        KIND_TO_CRD.put("DestinationPolicy", DESTINATION_POLICY_CRD_NAME);
        KIND_TO_CRD.put("EgressRule", EGRESS_RULE_CRD_NAME);
        KIND_TO_CRD.put("RouteRule", ROUTE_RULE_CRD_NAME);
    }
}

