/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.rbac.v1alpha1;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.rbac.v1alpha1.EnforcementMode;
import me.snowdrop.istio.api.rbac.v1alpha1.RoleRef;
import me.snowdrop.istio.api.rbac.v1alpha1.RoleRefBuilder;
import me.snowdrop.istio.api.rbac.v1alpha1.RoleRefFluentImpl;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBinding;
import me.snowdrop.istio.api.rbac.v1alpha1.ServiceRoleBindingFluent;
import me.snowdrop.istio.api.rbac.v1alpha1.Subject;
import me.snowdrop.istio.api.rbac.v1alpha1.SubjectBuilder;
import me.snowdrop.istio.api.rbac.v1alpha1.SubjectFluentImpl;

public class ServiceRoleBindingFluentImpl<A extends ServiceRoleBindingFluent<A>>
extends BaseFluent<A>
implements ServiceRoleBindingFluent<A> {
    private EnforcementMode mode;
    private RoleRefBuilder roleRef;
    private List<SubjectBuilder> subjects;

    public ServiceRoleBindingFluentImpl() {
    }

    public ServiceRoleBindingFluentImpl(ServiceRoleBinding instance) {
        this.withMode(instance.getMode());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public EnforcementMode getMode() {
        return this.mode;
    }

    @Override
    public A withMode(EnforcementMode mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    @Deprecated
    public RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(RoleRef roleRef) {
        this._visitables.remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new RoleRefBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public A withNewRoleRef(String kind, String name) {
        return this.withRoleRef(new RoleRef(kind, name));
    }

    @Override
    public ServiceRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public ServiceRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public ServiceRoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public ServiceRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new RoleRefBuilder().build());
    }

    @Override
    public ServiceRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subject> getSubjects() {
        return ServiceRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<Subject> buildSubjects() {
        return ServiceRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<SubjectBuilder>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ServiceRoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply((Object)this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceRoleBindingFluentImpl that = (ServiceRoleBindingFluentImpl)o;
        if (this.mode != null ? !this.mode.equals((Object)that.mode) : that.mode != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public class SubjectsNestedImpl<N>
    extends SubjectFluentImpl<ServiceRoleBindingFluent.SubjectsNested<N>>
    implements ServiceRoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final SubjectBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceRoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends RoleRefFluentImpl<ServiceRoleBindingFluent.RoleRefNested<N>>
    implements ServiceRoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final RoleRefBuilder builder;

        RoleRefNestedImpl(RoleRef item) {
            this.builder = new RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceRoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }
}

