/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.policy.v1beta1.Rule;
import me.snowdrop.istio.api.policy.v1beta1.RuleFluent;
import me.snowdrop.istio.api.policy.v1beta1.RuleFluentImpl;

public class RuleBuilder
extends RuleFluentImpl<RuleBuilder>
implements VisitableBuilder<Rule, RuleBuilder> {
    RuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RuleBuilder() {
        this(true);
    }

    public RuleBuilder(Boolean validationEnabled) {
        this(new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RuleBuilder(RuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Rule(), validationEnabled);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance) {
        this(fluent, instance, true);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withActions(instance.getActions());
        fluent.withMatch(instance.getMatch());
        this.validationEnabled = validationEnabled;
    }

    public RuleBuilder(Rule instance) {
        this(instance, (Boolean)true);
    }

    public RuleBuilder(Rule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withActions(instance.getActions());
        this.withMatch(instance.getMatch());
        this.validationEnabled = validationEnabled;
    }

    public RuleBuilder(Validator validator) {
        this(new Rule(), (Boolean)true);
    }

    public RuleBuilder(RuleFluent<?> fluent, Rule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withActions(instance.getActions());
        fluent.withMatch(instance.getMatch());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RuleBuilder(Rule instance, Validator validator) {
        this.fluent = this;
        this.withActions(instance.getActions());
        this.withMatch(instance.getMatch());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Rule build() {
        Rule buildable = new Rule(this.fluent.getActions(), this.fluent.getMatch());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleBuilder that = (RuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

