/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntry;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntryFluent;
import me.snowdrop.istio.api.networking.v1alpha3.ServiceEntryFluentImpl;

public class ServiceEntryBuilder
extends ServiceEntryFluentImpl<ServiceEntryBuilder>
implements VisitableBuilder<ServiceEntry, ServiceEntryBuilder> {
    ServiceEntryFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ServiceEntryBuilder() {
        this(true);
    }

    public ServiceEntryBuilder(Boolean validationEnabled) {
        this(new ServiceEntry(), validationEnabled);
    }

    public ServiceEntryBuilder(ServiceEntryFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceEntryBuilder(ServiceEntryFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceEntry(), validationEnabled);
    }

    public ServiceEntryBuilder(ServiceEntryFluent<?> fluent, ServiceEntry instance) {
        this(fluent, instance, true);
    }

    public ServiceEntryBuilder(ServiceEntryFluent<?> fluent, ServiceEntry instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withHosts(instance.getHosts());
        fluent.withLocation(instance.getLocation());
        fluent.withPorts(instance.getPorts());
        fluent.withResolution(instance.getResolution());
        this.validationEnabled = validationEnabled;
    }

    public ServiceEntryBuilder(ServiceEntry instance) {
        this(instance, (Boolean)true);
    }

    public ServiceEntryBuilder(ServiceEntry instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withEndpoints(instance.getEndpoints());
        this.withHosts(instance.getHosts());
        this.withLocation(instance.getLocation());
        this.withPorts(instance.getPorts());
        this.withResolution(instance.getResolution());
        this.validationEnabled = validationEnabled;
    }

    public ServiceEntryBuilder(Validator validator) {
        this(new ServiceEntry(), (Boolean)true);
    }

    public ServiceEntryBuilder(ServiceEntryFluent<?> fluent, ServiceEntry instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withHosts(instance.getHosts());
        fluent.withLocation(instance.getLocation());
        fluent.withPorts(instance.getPorts());
        fluent.withResolution(instance.getResolution());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceEntryBuilder(ServiceEntry instance, Validator validator) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withEndpoints(instance.getEndpoints());
        this.withHosts(instance.getHosts());
        this.withLocation(instance.getLocation());
        this.withPorts(instance.getPorts());
        this.withResolution(instance.getResolution());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ServiceEntry build() {
        ServiceEntry buildable = new ServiceEntry(this.fluent.getAddresses(), this.fluent.getEndpoints(), this.fluent.getHosts(), this.fluent.getLocation(), this.fluent.getPorts(), this.fluent.getResolution());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceEntryBuilder that = (ServiceEntryBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

