/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.stackdriver;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.adapter.stackdriver.Stackdriver;
import me.snowdrop.istio.adapter.stackdriver.StackdriverFluent;
import me.snowdrop.istio.adapter.stackdriver.StackdriverFluentImpl;

public class StackdriverBuilder
extends StackdriverFluentImpl<StackdriverBuilder>
implements VisitableBuilder<Stackdriver, StackdriverBuilder> {
    StackdriverFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StackdriverBuilder() {
        this(true);
    }

    public StackdriverBuilder(Boolean validationEnabled) {
        this(new Stackdriver(), validationEnabled);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Stackdriver(), validationEnabled);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance) {
        this(fluent, instance, true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCreds(instance.getCreds());
        fluent.withEndpoint(instance.getEndpoint());
        fluent.withLogInfo(instance.getLogInfo());
        fluent.withMetricInfo(instance.getMetricInfo());
        fluent.withProjectId(instance.getProjectId());
        fluent.withPushInterval(instance.getPushInterval());
        fluent.withTrace(instance.getTrace());
        this.validationEnabled = validationEnabled;
    }

    public StackdriverBuilder(Stackdriver instance) {
        this(instance, (Boolean)true);
    }

    public StackdriverBuilder(Stackdriver instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCreds(instance.getCreds());
        this.withEndpoint(instance.getEndpoint());
        this.withLogInfo(instance.getLogInfo());
        this.withMetricInfo(instance.getMetricInfo());
        this.withProjectId(instance.getProjectId());
        this.withPushInterval(instance.getPushInterval());
        this.withTrace(instance.getTrace());
        this.validationEnabled = validationEnabled;
    }

    public StackdriverBuilder(Validator validator) {
        this(new Stackdriver(), (Boolean)true);
    }

    public StackdriverBuilder(StackdriverFluent<?> fluent, Stackdriver instance, Validator validator) {
        this.fluent = fluent;
        fluent.withCreds(instance.getCreds());
        fluent.withEndpoint(instance.getEndpoint());
        fluent.withLogInfo(instance.getLogInfo());
        fluent.withMetricInfo(instance.getMetricInfo());
        fluent.withProjectId(instance.getProjectId());
        fluent.withPushInterval(instance.getPushInterval());
        fluent.withTrace(instance.getTrace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public StackdriverBuilder(Stackdriver instance, Validator validator) {
        this.fluent = this;
        this.withCreds(instance.getCreds());
        this.withEndpoint(instance.getEndpoint());
        this.withLogInfo(instance.getLogInfo());
        this.withMetricInfo(instance.getMetricInfo());
        this.withProjectId(instance.getProjectId());
        this.withPushInterval(instance.getPushInterval());
        this.withTrace(instance.getTrace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Stackdriver build() {
        Stackdriver buildable = new Stackdriver(this.fluent.getCreds(), this.fluent.getEndpoint(), this.fluent.getLogInfo(), this.fluent.getMetricInfo(), this.fluent.getProjectId(), this.fluent.getPushInterval(), this.fluent.getTrace());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StackdriverBuilder that = (StackdriverBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

