/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.util;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.api.model.IstioSpec;
import me.snowdrop.istio.util.Utils;

public class YAML {
    private static final Pattern DOCUMENT_DELIMITER = Pattern.compile("---");
    private static final YAMLMapper objectMapper = new YAMLMapper();
    private static final String KIND = "kind";

    public static <T> T loadIstioResource(String specFileAsString, Class<T> clazz) {
        return YAML.loadIstioResources(specFileAsString, clazz).get(0);
    }

    public static <T> List<T> loadIstioResources(String specFileAsString, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        String[] documents = DOCUMENT_DELIMITER.split(specFileAsString);
        boolean wantSpec = IstioSpec.class.isAssignableFrom(clazz);
        if (!wantSpec && !IstioResource.class.equals(clazz)) {
            throw new IllegalArgumentException("Can only load either IstioSpec implementations or IstioResources. Asked to load: " + clazz.getName());
        }
        for (String document : documents) {
            try {
                document = document.trim();
                if (document.isEmpty()) continue;
                Map resourceYaml = (Map)objectMapper.readValue(document, Map.class);
                if (resourceYaml.containsKey(KIND)) {
                    String kind = (String)resourceYaml.get(KIND);
                    IstioSpecRegistry.getCRDNameFor(kind).orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a known Istio resource.", kind)));
                    IstioResource resource = (IstioResource)objectMapper.convertValue((Object)resourceYaml, IstioResource.class);
                    if (wantSpec) {
                        results.add(clazz.cast(resource.getSpec()));
                        continue;
                    }
                    results.add(clazz.cast(resource));
                    continue;
                }
                throw new IllegalArgumentException(String.format("%s is not specified in provided resource.", KIND));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return results;
    }

    public static <T> List<T> loadIstioResources(InputStream resource, Class<T> clazz) {
        return YAML.loadIstioResources(Utils.writeStreamToString(resource), clazz);
    }

    public static <T> T loadIstioResource(InputStream resource, Class<T> clazz) {
        return YAML.loadIstioResources(resource, clazz).get(0);
    }
}

