/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client;

import io.fabric8.kubernetes.api.model.v4_0.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_0.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.model.DoneableIstioResource;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.api.model.IstioResourceList;
import me.snowdrop.istio.client.Adapter;
import me.snowdrop.istio.util.Utils;
import me.snowdrop.istio.util.YAML;

public class IstioClient {
    private final Adapter client;

    public IstioClient(Adapter client) {
        this.client = client;
    }

    public List<IstioResource> registerCustomResources(String specFileAsString) {
        List<IstioResource> results = YAML.loadIstioResources(specFileAsString, IstioResource.class);
        switch (results.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return this.client.createCustomResources(results.get(0));
            }
        }
        return this.client.createCustomResources(results.toArray(new IstioResource[results.size()]));
    }

    public List<IstioResource> registerCustomResources(InputStream resource) {
        return this.registerCustomResources(Utils.writeStreamToString(resource));
    }

    public List<IstioResource> getResources(String kind) {
        String crdName = IstioSpecRegistry.getCRDNameFor(kind).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown kind %s", kind)));
        KubernetesClient client = this.getKubernetesClient();
        CustomResourceDefinition customResourceDefinition = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().withName(crdName)).get();
        if (customResourceDefinition == null) {
            throw new IllegalArgumentException(String.format("Custom Resource Definition %s is not found in cluster %s", crdName, client.getMasterUrl()));
        }
        KubernetesResourceList list = (KubernetesResourceList)((NonNamespaceOperation)client.customResources(customResourceDefinition, IstioResource.class, IstioResourceList.class, DoneableIstioResource.class).inNamespace(client.getNamespace())).list();
        return list.getItems();
    }

    public List<IstioResource> getResourcesLike(IstioResource resource) {
        if (resource == null) {
            return Collections.emptyList();
        }
        return this.getResources(resource.getKind());
    }

    public IstioResource registerCustomResource(IstioResource resource) {
        return this.client.createCustomResources(resource).get(0);
    }

    public IstioResource registerOrUpdateCustomResource(IstioResource resource) {
        return this.client.createOrReplaceCustomResources(resource).get(0);
    }

    public Boolean unregisterCustomResource(IstioResource istioResource) {
        return this.client.deleteCustomResources(istioResource);
    }

    public KubernetesClient getKubernetesClient() {
        return this.client.getKubernetesClient();
    }
}

