/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.model.v1.networking.VirtualService;
import me.snowdrop.istio.api.model.v1.networking.VirtualServiceFluent;
import me.snowdrop.istio.api.model.v1.networking.VirtualServiceFluentImpl;

public class VirtualServiceBuilder
extends VirtualServiceFluentImpl<VirtualServiceBuilder>
implements VisitableBuilder<VirtualService, VirtualServiceBuilder> {
    VirtualServiceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public VirtualServiceBuilder() {
        this(true);
    }

    public VirtualServiceBuilder(Boolean validationEnabled) {
        this(new VirtualService(), validationEnabled);
    }

    public VirtualServiceBuilder(VirtualServiceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VirtualServiceBuilder(VirtualServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VirtualService(), validationEnabled);
    }

    public VirtualServiceBuilder(VirtualServiceFluent<?> fluent, VirtualService instance) {
        this(fluent, instance, true);
    }

    public VirtualServiceBuilder(VirtualServiceFluent<?> fluent, VirtualService instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withGateways(instance.getGateways());
        fluent.withHosts(instance.getHosts());
        fluent.withHttp(instance.getHttp());
        fluent.withTcp(instance.getTcp());
        fluent.withTls(instance.getTls());
        this.validationEnabled = validationEnabled;
    }

    public VirtualServiceBuilder(VirtualService instance) {
        this(instance, (Boolean)true);
    }

    public VirtualServiceBuilder(VirtualService instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withGateways(instance.getGateways());
        this.withHosts(instance.getHosts());
        this.withHttp(instance.getHttp());
        this.withTcp(instance.getTcp());
        this.withTls(instance.getTls());
        this.validationEnabled = validationEnabled;
    }

    public VirtualServiceBuilder(Validator validator) {
        this(new VirtualService(), (Boolean)true);
    }

    public VirtualServiceBuilder(VirtualServiceFluent<?> fluent, VirtualService instance, Validator validator) {
        this.fluent = fluent;
        fluent.withGateways(instance.getGateways());
        fluent.withHosts(instance.getHosts());
        fluent.withHttp(instance.getHttp());
        fluent.withTcp(instance.getTcp());
        fluent.withTls(instance.getTls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public VirtualServiceBuilder(VirtualService instance, Validator validator) {
        this.fluent = this;
        this.withGateways(instance.getGateways());
        this.withHosts(instance.getHosts());
        this.withHttp(instance.getHttp());
        this.withTcp(instance.getTcp());
        this.withTls(instance.getTls());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public VirtualService build() {
        VirtualService buildable = new VirtualService(this.fluent.getGateways(), this.fluent.getHosts(), this.fluent.getHttp(), this.fluent.getTcp(), this.fluent.getTls());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualServiceBuilder that = (VirtualServiceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

