/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.TLSSettings;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsFluent;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsMode;

public class TLSSettingsFluentImpl<A extends TLSSettingsFluent<A>>
extends BaseFluent<A>
implements TLSSettingsFluent<A> {
    private String caCertificates;
    private String clientCertificate;
    private TLSSettingsMode mode;
    private String privateKey;
    private String sni;
    private List<String> subjectAltNames;

    public TLSSettingsFluentImpl() {
    }

    public TLSSettingsFluentImpl(TLSSettings instance) {
        this.withCaCertificates(instance.getCaCertificates());
        this.withClientCertificate(instance.getClientCertificate());
        this.withMode(instance.getMode());
        this.withPrivateKey(instance.getPrivateKey());
        this.withSni(instance.getSni());
        this.withSubjectAltNames(instance.getSubjectAltNames());
    }

    @Override
    public String getCaCertificates() {
        return this.caCertificates;
    }

    @Override
    public A withCaCertificates(String caCertificates) {
        this.caCertificates = caCertificates;
        return (A)this;
    }

    @Override
    public Boolean hasCaCertificates() {
        return this.caCertificates != null;
    }

    @Override
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    @Override
    public TLSSettingsMode getMode() {
        return this.mode;
    }

    @Override
    public A withMode(TLSSettingsMode mode) {
        this.mode = mode;
        return (A)this;
    }

    @Override
    public Boolean hasMode() {
        return this.mode != null;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public A withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return (A)this;
    }

    @Override
    public Boolean hasPrivateKey() {
        return this.privateKey != null;
    }

    @Override
    public String getSni() {
        return this.sni;
    }

    @Override
    public A withSni(String sni) {
        this.sni = sni;
        return (A)this;
    }

    @Override
    public Boolean hasSni() {
        return this.sni != null;
    }

    @Override
    public A addToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubjectAltNames(int index, String item) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubjectAltNames(String ... items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjectAltNames(Collection<String> items) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.subjectAltNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjectAltNames(String ... items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjectAltNames(Collection<String> items) {
        for (String item : items) {
            if (this.subjectAltNames == null) continue;
            this.subjectAltNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    @Override
    public String getSubjectAltName(int index) {
        return this.subjectAltNames.get(index);
    }

    @Override
    public String getFirstSubjectAltName() {
        return this.subjectAltNames.get(0);
    }

    @Override
    public String getLastSubjectAltName() {
        return this.subjectAltNames.get(this.subjectAltNames.size() - 1);
    }

    @Override
    public String getMatchingSubjectAltName(Predicate<String> predicate) {
        for (String item : this.subjectAltNames) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withSubjectAltNames(List<String> subjectAltNames) {
        if (this.subjectAltNames != null) {
            this._visitables.removeAll(this.subjectAltNames);
        }
        if (subjectAltNames != null) {
            this.subjectAltNames = new ArrayList<String>();
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        } else {
            this.subjectAltNames = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjectAltNames(String ... subjectAltNames) {
        if (this.subjectAltNames != null) {
            this.subjectAltNames.clear();
        }
        if (subjectAltNames != null) {
            for (String item : subjectAltNames) {
                this.addToSubjectAltNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjectAltNames() {
        return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSSettingsFluentImpl that = (TLSSettingsFluentImpl)o;
        if (this.caCertificates != null ? !this.caCertificates.equals(that.caCertificates) : that.caCertificates != null) {
            return false;
        }
        if (this.clientCertificate != null ? !this.clientCertificate.equals(that.clientCertificate) : that.clientCertificate != null) {
            return false;
        }
        if (this.mode != null ? !this.mode.equals((Object)that.mode) : that.mode != null) {
            return false;
        }
        if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) {
            return false;
        }
        if (this.sni != null ? !this.sni.equals(that.sni) : that.sni != null) {
            return false;
        }
        return !(this.subjectAltNames != null ? !this.subjectAltNames.equals(that.subjectAltNames) : that.subjectAltNames != null);
    }
}

