/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.Endpoint;
import me.snowdrop.istio.api.model.v1.networking.EndpointBuilder;
import me.snowdrop.istio.api.model.v1.networking.EndpointFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.Port;
import me.snowdrop.istio.api.model.v1.networking.PortBuilder;
import me.snowdrop.istio.api.model.v1.networking.PortFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.ServiceEntry;
import me.snowdrop.istio.api.model.v1.networking.ServiceEntryFluent;
import me.snowdrop.istio.api.model.v1.networking.ServiceEntryLocation;
import me.snowdrop.istio.api.model.v1.networking.ServiceEntryResolution;

public class ServiceEntryFluentImpl<A extends ServiceEntryFluent<A>>
extends BaseFluent<A>
implements ServiceEntryFluent<A> {
    private List<String> addresses;
    private List<EndpointBuilder> endpoints;
    private List<String> hosts;
    private ServiceEntryLocation location;
    private List<PortBuilder> ports;
    private ServiceEntryResolution resolution;

    public ServiceEntryFluentImpl() {
    }

    public ServiceEntryFluentImpl(ServiceEntry instance) {
        this.withAddresses(instance.getAddresses());
        this.withEndpoints(instance.getEndpoints());
        this.withHosts(instance.getHosts());
        this.withLocation(instance.getLocation());
        this.withPorts(instance.getPorts());
        this.withResolution(instance.getResolution());
    }

    @Override
    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(String ... items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAddresses(List<String> addresses) {
        if (this.addresses != null) {
            this._visitables.removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(Endpoint ... items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Endpoint> getEndpoints() {
        return ServiceEntryFluentImpl.build(this.endpoints);
    }

    @Override
    public List<Endpoint> buildEndpoints() {
        return ServiceEntryFluentImpl.build(this.endpoints);
    }

    @Override
    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public ServiceEntryFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.apply((Object)this.endpoints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public ServiceEntryLocation getLocation() {
        return this.location;
    }

    @Override
    public A withLocation(ServiceEntryLocation location) {
        this.location = location;
        return (A)this;
    }

    @Override
    public Boolean hasLocation() {
        return this.location != null;
    }

    @Override
    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Port> getPorts() {
        return ServiceEntryFluentImpl.build(this.ports);
    }

    @Override
    public List<Port> buildPorts() {
        return ServiceEntryFluentImpl.build(this.ports);
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<Port> ports) {
        if (this.ports != null) {
            this._visitables.removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<PortBuilder>();
            for (Port item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String name, Integer number, String protocol) {
        return this.addToPorts(new Port(name, number, protocol));
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntryFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply((Object)this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ServiceEntryResolution getResolution() {
        return this.resolution;
    }

    @Override
    public A withResolution(ServiceEntryResolution resolution) {
        this.resolution = resolution;
        return (A)this;
    }

    @Override
    public Boolean hasResolution() {
        return this.resolution != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceEntryFluentImpl that = (ServiceEntryFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals((Object)that.location) : that.location != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.resolution != null ? !this.resolution.equals((Object)that.resolution) : that.resolution != null);
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ServiceEntryFluent.PortsNested<N>>
    implements ServiceEntryFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntryFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends EndpointFluentImpl<ServiceEntryFluent.EndpointsNested<N>>
    implements ServiceEntryFluent.EndpointsNested<N>,
    Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntryFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

