/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.model.v1.networking.Port;
import me.snowdrop.istio.api.model.v1.networking.PortFluent;
import me.snowdrop.istio.api.model.v1.networking.PortFluentImpl;

public class PortBuilder
extends PortFluentImpl<PortBuilder>
implements VisitableBuilder<Port, PortBuilder> {
    PortFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PortBuilder() {
        this(true);
    }

    public PortBuilder(Boolean validationEnabled) {
        this(new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PortBuilder(PortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance) {
        this(fluent, instance, true);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNumber(instance.getNumber());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public PortBuilder(Port instance) {
        this(instance, (Boolean)true);
    }

    public PortBuilder(Port instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNumber(instance.getNumber());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public PortBuilder(Validator validator) {
        this(new Port(), (Boolean)true);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance, Validator validator) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withNumber(instance.getNumber());
        fluent.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PortBuilder(Port instance, Validator validator) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withNumber(instance.getNumber());
        this.withProtocol(instance.getProtocol());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Port build() {
        Port buildable = new Port(this.fluent.getName(), this.fluent.getNumber(), this.fluent.getProtocol());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBuilder that = (PortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

