/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributes;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributesFluent;
import me.snowdrop.istio.api.model.v1.networking.L4MatchAttributesFluentImpl;

public class L4MatchAttributesBuilder
extends L4MatchAttributesFluentImpl<L4MatchAttributesBuilder>
implements VisitableBuilder<L4MatchAttributes, L4MatchAttributesBuilder> {
    L4MatchAttributesFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public L4MatchAttributesBuilder() {
        this(true);
    }

    public L4MatchAttributesBuilder(Boolean validationEnabled) {
        this(new L4MatchAttributes(), validationEnabled);
    }

    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new L4MatchAttributes(), validationEnabled);
    }

    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent, L4MatchAttributes instance) {
        this(fluent, instance, true);
    }

    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent, L4MatchAttributes instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestinationSubnets(instance.getDestinationSubnets());
        fluent.withGateways(instance.getGateways());
        fluent.withPort(instance.getPort());
        fluent.withSourceLabels(instance.getSourceLabels());
        fluent.withSourceSubnet(instance.getSourceSubnet());
        this.validationEnabled = validationEnabled;
    }

    public L4MatchAttributesBuilder(L4MatchAttributes instance) {
        this(instance, (Boolean)true);
    }

    public L4MatchAttributesBuilder(L4MatchAttributes instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestinationSubnets(instance.getDestinationSubnets());
        this.withGateways(instance.getGateways());
        this.withPort(instance.getPort());
        this.withSourceLabels(instance.getSourceLabels());
        this.withSourceSubnet(instance.getSourceSubnet());
        this.validationEnabled = validationEnabled;
    }

    public L4MatchAttributesBuilder(Validator validator) {
        this(new L4MatchAttributes(), (Boolean)true);
    }

    public L4MatchAttributesBuilder(L4MatchAttributesFluent<?> fluent, L4MatchAttributes instance, Validator validator) {
        this.fluent = fluent;
        fluent.withDestinationSubnets(instance.getDestinationSubnets());
        fluent.withGateways(instance.getGateways());
        fluent.withPort(instance.getPort());
        fluent.withSourceLabels(instance.getSourceLabels());
        fluent.withSourceSubnet(instance.getSourceSubnet());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public L4MatchAttributesBuilder(L4MatchAttributes instance, Validator validator) {
        this.fluent = this;
        this.withDestinationSubnets(instance.getDestinationSubnets());
        this.withGateways(instance.getGateways());
        this.withPort(instance.getPort());
        this.withSourceLabels(instance.getSourceLabels());
        this.withSourceSubnet(instance.getSourceSubnet());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public L4MatchAttributes build() {
        L4MatchAttributes buildable = new L4MatchAttributes(this.fluent.getDestinationSubnets(), this.fluent.getGateways(), this.fluent.getPort(), this.fluent.getSourceLabels(), this.fluent.getSourceSubnet());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        L4MatchAttributesBuilder that = (L4MatchAttributesBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

