/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.DestinationRule;
import me.snowdrop.istio.api.model.v1.networking.DestinationRuleFluent;
import me.snowdrop.istio.api.model.v1.networking.Subset;
import me.snowdrop.istio.api.model.v1.networking.SubsetBuilder;
import me.snowdrop.istio.api.model.v1.networking.SubsetFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.TrafficPolicy;
import me.snowdrop.istio.api.model.v1.networking.TrafficPolicyBuilder;
import me.snowdrop.istio.api.model.v1.networking.TrafficPolicyFluentImpl;

public class DestinationRuleFluentImpl<A extends DestinationRuleFluent<A>>
extends BaseFluent<A>
implements DestinationRuleFluent<A> {
    private String host;
    private List<SubsetBuilder> subsets;
    private TrafficPolicyBuilder trafficPolicy;

    public DestinationRuleFluentImpl() {
    }

    public DestinationRuleFluentImpl(DestinationRule instance) {
        this.withHost(instance.getHost());
        this.withSubsets(instance.getSubsets());
        this.withTrafficPolicy(instance.getTrafficPolicy());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public A addToSubsets(int index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.subsets.add(index >= 0 ? index : this.subsets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubsets(int index, Subset item) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        SubsetBuilder builder = new SubsetBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.subsets.size()) {
            this.subsets.add(builder);
        } else {
            this.subsets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubsets(Subset ... items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubsets(Collection<Subset> items) {
        if (this.subsets == null) {
            this.subsets = new ArrayList<SubsetBuilder>();
        }
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.add(builder);
            this.subsets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubsets(Subset ... items) {
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubsets(Collection<Subset> items) {
        for (Subset item : items) {
            SubsetBuilder builder = new SubsetBuilder(item);
            this._visitables.remove(builder);
            if (this.subsets == null) continue;
            this.subsets.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subset> getSubsets() {
        return DestinationRuleFluentImpl.build(this.subsets);
    }

    @Override
    public List<Subset> buildSubsets() {
        return DestinationRuleFluentImpl.build(this.subsets);
    }

    @Override
    public Subset buildSubset(int index) {
        return this.subsets.get(index).build();
    }

    @Override
    public Subset buildFirstSubset() {
        return this.subsets.get(0).build();
    }

    @Override
    public Subset buildLastSubset() {
        return this.subsets.get(this.subsets.size() - 1).build();
    }

    @Override
    public Subset buildMatchingSubset(Predicate<SubsetBuilder> predicate) {
        for (SubsetBuilder item : this.subsets) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSubsets(List<Subset> subsets) {
        if (this.subsets != null) {
            this._visitables.removeAll(this.subsets);
        }
        if (subsets != null) {
            this.subsets = new ArrayList<SubsetBuilder>();
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        } else {
            this.subsets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubsets(Subset ... subsets) {
        if (this.subsets != null) {
            this.subsets.clear();
        }
        if (subsets != null) {
            for (Subset item : subsets) {
                this.addToSubsets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubsets() {
        return this.subsets != null && !this.subsets.isEmpty();
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> addNewSubset() {
        return new SubsetsNestedImpl();
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> addNewSubsetLike(Subset item) {
        return new SubsetsNestedImpl(-1, item);
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> setNewSubsetLike(int index, Subset item) {
        return new SubsetsNestedImpl(index, item);
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> editSubset(int index) {
        if (this.subsets.size() <= index) {
            throw new RuntimeException("Can't edit subsets. Index exceeds size.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> editFirstSubset() {
        if (this.subsets.size() == 0) {
            throw new RuntimeException("Can't edit first subsets. The list is empty.");
        }
        return this.setNewSubsetLike(0, this.buildSubset(0));
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> editLastSubset() {
        int index = this.subsets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subsets. The list is empty.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    public DestinationRuleFluent.SubsetsNested<A> editMatchingSubset(Predicate<SubsetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subsets.size(); ++i) {
            if (!predicate.apply((Object)this.subsets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subsets. No match found.");
        }
        return this.setNewSubsetLike(index, this.buildSubset(index));
    }

    @Override
    @Deprecated
    public TrafficPolicy getTrafficPolicy() {
        return this.trafficPolicy != null ? this.trafficPolicy.build() : null;
    }

    @Override
    public TrafficPolicy buildTrafficPolicy() {
        return this.trafficPolicy != null ? this.trafficPolicy.build() : null;
    }

    @Override
    public A withTrafficPolicy(TrafficPolicy trafficPolicy) {
        this._visitables.remove(this.trafficPolicy);
        if (trafficPolicy != null) {
            this.trafficPolicy = new TrafficPolicyBuilder(trafficPolicy);
            this._visitables.add(this.trafficPolicy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrafficPolicy() {
        return this.trafficPolicy != null;
    }

    @Override
    public DestinationRuleFluent.TrafficPolicyNested<A> withNewTrafficPolicy() {
        return new TrafficPolicyNestedImpl();
    }

    @Override
    public DestinationRuleFluent.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item) {
        return new TrafficPolicyNestedImpl(item);
    }

    @Override
    public DestinationRuleFluent.TrafficPolicyNested<A> editTrafficPolicy() {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy());
    }

    @Override
    public DestinationRuleFluent.TrafficPolicyNested<A> editOrNewTrafficPolicy() {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy() != null ? this.getTrafficPolicy() : new TrafficPolicyBuilder().build());
    }

    @Override
    public DestinationRuleFluent.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item) {
        return this.withNewTrafficPolicyLike(this.getTrafficPolicy() != null ? this.getTrafficPolicy() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestinationRuleFluentImpl that = (DestinationRuleFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.subsets != null ? !this.subsets.equals(that.subsets) : that.subsets != null) {
            return false;
        }
        return !(this.trafficPolicy != null ? !this.trafficPolicy.equals(that.trafficPolicy) : that.trafficPolicy != null);
    }

    public class TrafficPolicyNestedImpl<N>
    extends TrafficPolicyFluentImpl<DestinationRuleFluent.TrafficPolicyNested<N>>
    implements DestinationRuleFluent.TrafficPolicyNested<N>,
    Nested<N> {
        private final TrafficPolicyBuilder builder;

        TrafficPolicyNestedImpl(TrafficPolicy item) {
            this.builder = new TrafficPolicyBuilder(this, item);
        }

        TrafficPolicyNestedImpl() {
            this.builder = new TrafficPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DestinationRuleFluentImpl.this.withTrafficPolicy(this.builder.build());
        }

        @Override
        public N endTrafficPolicy() {
            return this.and();
        }
    }

    public class SubsetsNestedImpl<N>
    extends SubsetFluentImpl<DestinationRuleFluent.SubsetsNested<N>>
    implements DestinationRuleFluent.SubsetsNested<N>,
    Nested<N> {
        private final SubsetBuilder builder;
        private final int index;

        SubsetsNestedImpl(int index, Subset item) {
            this.index = index;
            this.builder = new SubsetBuilder(this, item);
        }

        SubsetsNestedImpl() {
            this.index = -1;
            this.builder = new SubsetBuilder(this);
        }

        @Override
        public N and() {
            return (N)DestinationRuleFluentImpl.this.setToSubsets(this.index, this.builder.build());
        }

        @Override
        public N endSubset() {
            return this.and();
        }
    }
}

