/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.authentication;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.api.model.v1.authentication.JwtParams;
import me.snowdrop.istio.api.model.v1.authentication.JwtParamsFluent;
import me.snowdrop.istio.api.model.v1.authentication.JwtParamsFluentImpl;

public class JwtParamsBuilder
extends JwtParamsFluentImpl<JwtParamsBuilder>
implements VisitableBuilder<JwtParams, JwtParamsBuilder> {
    JwtParamsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public JwtParamsBuilder() {
        this(true);
    }

    public JwtParamsBuilder(Boolean validationEnabled) {
        this(new JwtParams(), validationEnabled);
    }

    public JwtParamsBuilder(JwtParamsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JwtParamsBuilder(JwtParamsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JwtParams(), validationEnabled);
    }

    public JwtParamsBuilder(JwtParamsFluent<?> fluent, JwtParams instance) {
        this(fluent, instance, true);
    }

    public JwtParamsBuilder(JwtParamsFluent<?> fluent, JwtParams instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withJwt(instance.getJwt());
        this.validationEnabled = validationEnabled;
    }

    public JwtParamsBuilder(JwtParams instance) {
        this(instance, (Boolean)true);
    }

    public JwtParamsBuilder(JwtParams instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withJwt(instance.getJwt());
        this.validationEnabled = validationEnabled;
    }

    public JwtParamsBuilder(Validator validator) {
        this(new JwtParams(), (Boolean)true);
    }

    public JwtParamsBuilder(JwtParamsFluent<?> fluent, JwtParams instance, Validator validator) {
        this.fluent = fluent;
        fluent.withJwt(instance.getJwt());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JwtParamsBuilder(JwtParams instance, Validator validator) {
        this.fluent = this;
        this.withJwt(instance.getJwt());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public JwtParams build() {
        JwtParams buildable = new JwtParams(this.fluent.getJwt());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtParamsBuilder that = (JwtParamsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

