/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.authentication;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.authentication.Jwt;
import me.snowdrop.istio.api.model.v1.authentication.JwtFluent;

public class JwtFluentImpl<A extends JwtFluent<A>>
extends BaseFluent<A>
implements JwtFluent<A> {
    private List<String> audiences;
    private String issuer;
    private String jwksUri;
    private List<String> jwtHeaders;
    private List<String> jwtParams;

    public JwtFluentImpl() {
    }

    public JwtFluentImpl(Jwt instance) {
        this.withAudiences(instance.getAudiences());
        this.withIssuer(instance.getIssuer());
        this.withJwksUri(instance.getJwksUri());
        this.withJwtHeaders(instance.getJwtHeaders());
        this.withJwtParams(instance.getJwtParams());
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (this.audiences != null) {
            this._visitables.removeAll(this.audiences);
        }
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    @Override
    public Boolean hasIssuer() {
        return this.issuer != null;
    }

    @Override
    public String getJwksUri() {
        return this.jwksUri;
    }

    @Override
    public A withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return (A)this;
    }

    @Override
    public Boolean hasJwksUri() {
        return this.jwksUri != null;
    }

    @Override
    public A addToJwtHeaders(int index, String item) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        this.jwtHeaders.add(index, item);
        return (A)this;
    }

    @Override
    public A setToJwtHeaders(int index, String item) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        this.jwtHeaders.set(index, item);
        return (A)this;
    }

    @Override
    public A addToJwtHeaders(String ... items) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtHeaders.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToJwtHeaders(Collection<String> items) {
        if (this.jwtHeaders == null) {
            this.jwtHeaders = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtHeaders.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromJwtHeaders(String ... items) {
        for (String item : items) {
            if (this.jwtHeaders == null) continue;
            this.jwtHeaders.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJwtHeaders(Collection<String> items) {
        for (String item : items) {
            if (this.jwtHeaders == null) continue;
            this.jwtHeaders.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getJwtHeaders() {
        return this.jwtHeaders;
    }

    @Override
    public String getJwtHeader(int index) {
        return this.jwtHeaders.get(index);
    }

    @Override
    public String getFirstJwtHeader() {
        return this.jwtHeaders.get(0);
    }

    @Override
    public String getLastJwtHeader() {
        return this.jwtHeaders.get(this.jwtHeaders.size() - 1);
    }

    @Override
    public String getMatchingJwtHeader(Predicate<String> predicate) {
        for (String item : this.jwtHeaders) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withJwtHeaders(List<String> jwtHeaders) {
        if (this.jwtHeaders != null) {
            this._visitables.removeAll(this.jwtHeaders);
        }
        if (jwtHeaders != null) {
            this.jwtHeaders = new ArrayList<String>();
            for (String item : jwtHeaders) {
                this.addToJwtHeaders(item);
            }
        } else {
            this.jwtHeaders = null;
        }
        return (A)this;
    }

    @Override
    public A withJwtHeaders(String ... jwtHeaders) {
        if (this.jwtHeaders != null) {
            this.jwtHeaders.clear();
        }
        if (jwtHeaders != null) {
            for (String item : jwtHeaders) {
                this.addToJwtHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJwtHeaders() {
        return this.jwtHeaders != null && !this.jwtHeaders.isEmpty();
    }

    @Override
    public A addToJwtParams(int index, String item) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        this.jwtParams.add(index, item);
        return (A)this;
    }

    @Override
    public A setToJwtParams(int index, String item) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        this.jwtParams.set(index, item);
        return (A)this;
    }

    @Override
    public A addToJwtParams(String ... items) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToJwtParams(Collection<String> items) {
        if (this.jwtParams == null) {
            this.jwtParams = new ArrayList<String>();
        }
        for (String item : items) {
            this.jwtParams.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromJwtParams(String ... items) {
        for (String item : items) {
            if (this.jwtParams == null) continue;
            this.jwtParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromJwtParams(Collection<String> items) {
        for (String item : items) {
            if (this.jwtParams == null) continue;
            this.jwtParams.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getJwtParams() {
        return this.jwtParams;
    }

    @Override
    public String getJwtParam(int index) {
        return this.jwtParams.get(index);
    }

    @Override
    public String getFirstJwtParam() {
        return this.jwtParams.get(0);
    }

    @Override
    public String getLastJwtParam() {
        return this.jwtParams.get(this.jwtParams.size() - 1);
    }

    @Override
    public String getMatchingJwtParam(Predicate<String> predicate) {
        for (String item : this.jwtParams) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withJwtParams(List<String> jwtParams) {
        if (this.jwtParams != null) {
            this._visitables.removeAll(this.jwtParams);
        }
        if (jwtParams != null) {
            this.jwtParams = new ArrayList<String>();
            for (String item : jwtParams) {
                this.addToJwtParams(item);
            }
        } else {
            this.jwtParams = null;
        }
        return (A)this;
    }

    @Override
    public A withJwtParams(String ... jwtParams) {
        if (this.jwtParams != null) {
            this.jwtParams.clear();
        }
        if (jwtParams != null) {
            for (String item : jwtParams) {
                this.addToJwtParams(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasJwtParams() {
        return this.jwtParams != null && !this.jwtParams.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JwtFluentImpl that = (JwtFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null) {
            return false;
        }
        if (this.jwksUri != null ? !this.jwksUri.equals(that.jwksUri) : that.jwksUri != null) {
            return false;
        }
        if (this.jwtHeaders != null ? !this.jwtHeaders.equals(that.jwtHeaders) : that.jwtHeaders != null) {
            return false;
        }
        return !(this.jwtParams != null ? !this.jwtParams.equals(that.jwtParams) : that.jwtParams != null);
    }
}

