/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v4_0.HasMetadata;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMeta;
import java.io.Serializable;
import me.snowdrop.istio.api.internal.IstioDeserializer;
import me.snowdrop.istio.api.model.IstioSpec;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec"})
@JsonDeserialize(using=IstioDeserializer.class)
public class IstioResource
implements HasMetadata,
Serializable {
    private ObjectMeta metadata;
    private String kind;
    private String apiVersion = "config.istio.io/v1alpha2";
    private IstioSpec spec;

    public IstioResource() {
    }

    public IstioResource(String apiVersion, String kind, ObjectMeta metadata, IstioSpec spec) {
        this.metadata = metadata;
        this.kind = kind;
        this.apiVersion = apiVersion;
        this.spec = spec;
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public String getKind() {
        if (this.kind == null && this.spec != null) {
            this.kind = this.spec.getKind();
        }
        return this.kind;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IstioSpec getSpec() {
        return this.spec;
    }

    public void setSpec(IstioSpec spec) {
        this.spec = spec;
    }

    public String toString() {
        return "IstioResource(metadata=" + this.getMetadata() + ", kind=" + this.getKind() + ", apiVersion=" + this.getApiVersion() + ", spec=" + this.getSpec() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IstioResource)) {
            return false;
        }
        IstioResource other = (IstioResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        IstioSpec this$spec = this.getSpec();
        IstioSpec other$spec = other.getSpec();
        return !(this$spec == null ? other$spec != null : !this$spec.equals(other$spec));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IstioResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        IstioSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        return result;
    }
}

