/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfacesRegistry {
    private static Map<String, Map<String, String>> classNameToFieldInfos = new HashMap<String, Map<String, String>>();

    static FieldInfo getFieldInfo(String targetClassName, String fieldName) {
        String type = (String)classNameToFieldInfos.getOrDefault(targetClassName, Collections.emptyMap()).get(fieldName);
        if (type == null) {
            throw new IllegalArgumentException("Unknown field '" + fieldName + "'");
        }
        if (type.startsWith("is")) {
            String interfaceName = type.substring(type.lastIndexOf(95) + 1);
            String target = interfaceName.substring(0, 1).toLowerCase() + interfaceName.substring(1);
            String impl = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            return new FieldInfo(target, impl + interfaceName);
        }
        return new FieldInfo(fieldName, type);
    }

    static {
        YAMLMapper mapper = new YAMLMapper();
        InputStream dataIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("interfaces-data.yml");
        try {
            Classes classes = (Classes)mapper.readValue(dataIs, Classes.class);
            classes.classes.forEach(ci -> classNameToFieldInfos.put(((ClassInfo)ci).className, ((ClassInfo)ci).fields));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class FieldInfo {
        final String target;
        final String type;

        private FieldInfo(String target, String type) {
            this.target = target;
            this.type = type;
        }
    }

    private static class ClassInfo {
        @JsonProperty(value="class")
        private String className;
        @JsonProperty
        private Map<String, String> fields;

        private ClassInfo() {
        }
    }

    private static class Classes {
        @JsonProperty
        private List<ClassInfo> classes;

        private Classes() {
        }
    }
}

