/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import me.snowdrop.istio.api.internal.InterfacesRegistry;

public class ClassWithInterfaceFieldsDeserializer
extends JsonDeserializer
implements ContextualDeserializer {
    private String targetClassName;

    public ClassWithInterfaceFieldsDeserializer() {
    }

    private ClassWithInterfaceFieldsDeserializer(String targetClassName) {
        this.targetClassName = targetClassName;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object result;
        Class<?> targetClass;
        ObjectNode node = (ObjectNode)p.readValueAsTree();
        try {
            targetClass = Thread.currentThread().getContextClassLoader().loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(this.targetClassName + " doesn't appear to be a known Istio class", e);
        }
        try {
            result = targetClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't create an instance of " + this.targetClassName, e);
        }
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Object deserialized;
            Map.Entry field = (Map.Entry)fields.next();
            String fieldName = (String)field.getKey();
            InterfacesRegistry.FieldInfo info = InterfacesRegistry.getFieldInfo(this.targetClassName, fieldName);
            JsonNode value = (JsonNode)field.getValue();
            switch (info.type) {
                case "integer": {
                    deserialized = value.intValue();
                    break;
                }
                case "string": {
                    deserialized = value.textValue();
                    break;
                }
                case "number": {
                    deserialized = value.doubleValue();
                    break;
                }
                case "boolean": {
                    deserialized = value.booleanValue();
                    break;
                }
                default: {
                    String type = targetClass.getPackage().getName() + '.' + info.type;
                    try {
                        Class<?> fieldClass = Thread.currentThread().getContextClassLoader().loadClass(type);
                        deserialized = p.getCodec().treeToValue((TreeNode)node, fieldClass);
                        break;
                    }
                    catch (JsonProcessingException | ClassNotFoundException e) {
                        throw new RuntimeException("Unsupported type '" + type + "' for field '" + fieldName + "' on '" + this.targetClassName + "' class", e);
                    }
                }
            }
            try {
                Field targetClassField = targetClass.getDeclaredField(info.target);
                targetClassField.setAccessible(true);
                targetClassField.set(result, deserialized);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Couldn't assign '" + deserialized + "' to '" + info.target + "' target field on '" + this.targetClassName + "' class", e);
            }
        }
        return result;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Class classToDeserialize = property.getType().getRawClass();
        return new ClassWithInterfaceFieldsDeserializer(classToDeserialize.getName());
    }
}

