/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import javax.validation.Validator;
import me.snowdrop.istio.adapter.fluentd.Fluentd;
import me.snowdrop.istio.adapter.fluentd.FluentdFluent;
import me.snowdrop.istio.adapter.fluentd.FluentdFluentImpl;

public class FluentdBuilder
extends FluentdFluentImpl<FluentdBuilder>
implements VisitableBuilder<Fluentd, FluentdBuilder> {
    FluentdFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public FluentdBuilder() {
        this(true);
    }

    public FluentdBuilder(Boolean validationEnabled) {
        this(new Fluentd(), validationEnabled);
    }

    public FluentdBuilder(FluentdFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public FluentdBuilder(FluentdFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Fluentd(), validationEnabled);
    }

    public FluentdBuilder(FluentdFluent<?> fluent, Fluentd instance) {
        this(fluent, instance, true);
    }

    public FluentdBuilder(FluentdFluent<?> fluent, Fluentd instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withIntegerDuration(instance.getIntegerDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdBuilder(Fluentd instance) {
        this(instance, (Boolean)true);
    }

    public FluentdBuilder(Fluentd instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withIntegerDuration(instance.getIntegerDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdBuilder(Validator validator) {
        this(new Fluentd(), (Boolean)true);
    }

    public FluentdBuilder(FluentdFluent<?> fluent, Fluentd instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withIntegerDuration(instance.getIntegerDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public FluentdBuilder(Fluentd instance, Validator validator) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withIntegerDuration(instance.getIntegerDuration());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Fluentd build() {
        Fluentd buildable = new Fluentd(this.fluent.getAddress(), this.fluent.isIntegerDuration());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FluentdBuilder that = (FluentdBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

