/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v4_0.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v4_0.KubernetesClient;
import io.fabric8.kubernetes.clnt.v4_0.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.snowdrop.istio.api.internal.IstioSpecRegistry;
import me.snowdrop.istio.api.model.DoneableIstioResource;
import me.snowdrop.istio.api.model.IstioResource;
import me.snowdrop.istio.api.model.IstioResourceList;
import me.snowdrop.istio.client.Adapter;

public class IstioClient {
    private static final Pattern DOCUMENT_DELIMITER = Pattern.compile("---");
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String KIND = "kind";
    private final Adapter client;

    public IstioClient(Adapter client) {
        this.client = client;
    }

    public List<IstioResource> registerCustomResources(String specFileAsString) {
        String[] documents;
        ArrayList<IstioResource> results = new ArrayList<IstioResource>();
        for (String document : documents = DOCUMENT_DELIMITER.split(specFileAsString)) {
            try {
                document = document.trim();
                if (document.isEmpty()) continue;
                Map resourceYaml = (Map)objectMapper.readValue(document, Map.class);
                if (resourceYaml.containsKey(KIND)) {
                    String kind = (String)resourceYaml.get(KIND);
                    IstioSpecRegistry.getCRDNameFor(kind).orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a known Istio resource.", kind)));
                    IstioResource resource = (IstioResource)objectMapper.convertValue((Object)resourceYaml, IstioResource.class);
                    results.add(resource);
                    continue;
                }
                throw new IllegalArgumentException(String.format("%s is not specified in provided resource.", KIND));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        switch (documents.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return this.client.createCustomResources((IstioResource)results.get(0));
            }
        }
        return this.client.createCustomResources(results.toArray(new IstioResource[results.size()]));
    }

    public List<IstioResource> registerCustomResources(InputStream resource) {
        return this.registerCustomResources(IstioClient.readSpecFileFromInputStream(resource));
    }

    public List<IstioResource> getResources(String kind) {
        String crdName = IstioSpecRegistry.getCRDNameFor(kind).orElseThrow(() -> new IllegalArgumentException(String.format("Unknown kind %s", kind)));
        KubernetesClient client = this.getKubernetesClient();
        CustomResourceDefinition customResourceDefinition = (CustomResourceDefinition)((Resource)client.customResourceDefinitions().withName(crdName)).get();
        if (customResourceDefinition == null) {
            throw new IllegalArgumentException(String.format("Custom Resource Definition %s is not found in cluster %s", crdName, client.getMasterUrl()));
        }
        KubernetesResourceList list = (KubernetesResourceList)((NonNamespaceOperation)client.customResources(customResourceDefinition, IstioResource.class, IstioResourceList.class, DoneableIstioResource.class).inNamespace(client.getNamespace())).list();
        return list.getItems();
    }

    public List<IstioResource> getResourcesLike(IstioResource resource) {
        if (resource == null) {
            return Collections.emptyList();
        }
        return this.getResources(resource.getKind());
    }

    public IstioResource registerCustomResource(IstioResource resource) {
        return this.client.createCustomResources(resource).get(0);
    }

    public IstioResource registerOrUpdateCustomResource(IstioResource resource) {
        return this.client.createOrReplaceCustomResources(resource).get(0);
    }

    public Boolean unregisterCustomResource(IstioResource istioResource) {
        return this.client.deleteCustomResources(istioResource);
    }

    private static String readSpecFileFromInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read InputStream.", e);
        }
    }

    public KubernetesClient getKubernetesClient() {
        return this.client.getKubernetesClient();
    }
}

