/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.routing.Throttle;
import me.snowdrop.istio.api.model.v1.routing.ThrottleFluent;
import me.snowdrop.istio.api.model.v1.routing.ThrottleFluentImpl;

public class ThrottleBuilder
extends ThrottleFluentImpl<ThrottleBuilder>
implements VisitableBuilder<Throttle, ThrottleBuilder> {
    ThrottleFluent<?> fluent;
    Boolean validationEnabled;

    public ThrottleBuilder() {
        this(true);
    }

    public ThrottleBuilder(Boolean validationEnabled) {
        this(new Throttle(), validationEnabled);
    }

    public ThrottleBuilder(ThrottleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ThrottleBuilder(ThrottleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Throttle(), validationEnabled);
    }

    public ThrottleBuilder(ThrottleFluent<?> fluent, Throttle instance) {
        this(fluent, instance, true);
    }

    public ThrottleBuilder(ThrottleFluent<?> fluent, Throttle instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withThrottleAfter(instance.getThrottleAfter());
        fluent.withDownstreamLimitBps(instance.getDownstreamLimitBps());
        fluent.withPercent(instance.getPercent());
        fluent.withThrottleForPeriod(instance.getThrottleForPeriod());
        fluent.withUpstreamLimitBps(instance.getUpstreamLimitBps());
        this.validationEnabled = validationEnabled;
    }

    public ThrottleBuilder(Throttle instance) {
        this(instance, (Boolean)true);
    }

    public ThrottleBuilder(Throttle instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withThrottleAfter(instance.getThrottleAfter());
        this.withDownstreamLimitBps(instance.getDownstreamLimitBps());
        this.withPercent(instance.getPercent());
        this.withThrottleForPeriod(instance.getThrottleForPeriod());
        this.withUpstreamLimitBps(instance.getUpstreamLimitBps());
        this.validationEnabled = validationEnabled;
    }

    public Throttle build() {
        Throttle buildable = new Throttle(this.fluent.getThrottleAfter(), this.fluent.getDownstreamLimitBps(), this.fluent.getPercent(), this.fluent.getThrottleForPeriod(), this.fluent.getUpstreamLimitBps());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThrottleBuilder that = (ThrottleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

