/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import me.snowdrop.istio.api.model.v1.routing.IngressRule;
import me.snowdrop.istio.api.model.v1.routing.IngressRuleFluent;
import me.snowdrop.istio.api.model.v1.routing.IstioService;
import me.snowdrop.istio.api.model.v1.routing.IstioServiceBuilder;
import me.snowdrop.istio.api.model.v1.routing.IstioServiceFluentImpl;
import me.snowdrop.istio.api.model.v1.routing.MatchCondition;
import me.snowdrop.istio.api.model.v1.routing.MatchConditionBuilder;
import me.snowdrop.istio.api.model.v1.routing.MatchConditionFluentImpl;

public class IngressRuleFluentImpl<A extends IngressRuleFluent<A>>
extends BaseFluent<A>
implements IngressRuleFluent<A> {
    private Object destinationServicePort;
    private IstioServiceBuilder destination;
    private MatchConditionBuilder match;
    private Integer port;
    private Integer precedence;
    private String tlsSecret;

    public IngressRuleFluentImpl() {
    }

    public IngressRuleFluentImpl(IngressRule instance) {
        this.withDestinationServicePort(instance.getDestinationServicePort());
        this.withDestination(instance.getDestination());
        this.withMatch(instance.getMatch());
        this.withPort(instance.getPort());
        this.withPrecedence(instance.getPrecedence());
        this.withTlsSecret(instance.getTlsSecret());
    }

    @Override
    public Object getDestinationServicePort() {
        return this.destinationServicePort;
    }

    @Override
    public A withDestinationServicePort(Object destinationServicePort) {
        this.destinationServicePort = destinationServicePort;
        return (A)this;
    }

    @Override
    public Boolean hasDestinationServicePort() {
        return this.destinationServicePort != null;
    }

    @Override
    @Deprecated
    public IstioService getDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public IstioService buildDestination() {
        return this.destination != null ? this.destination.build() : null;
    }

    @Override
    public A withDestination(IstioService destination) {
        this._visitables.remove(this.destination);
        if (destination != null) {
            this.destination = new IstioServiceBuilder(destination);
            this._visitables.add(this.destination);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDestination() {
        return this.destination != null;
    }

    @Override
    public IngressRuleFluent.DestinationNested<A> withNewDestination() {
        return new DestinationNestedImpl();
    }

    @Override
    public IngressRuleFluent.DestinationNested<A> withNewDestinationLike(IstioService item) {
        return new DestinationNestedImpl(item);
    }

    @Override
    public IngressRuleFluent.DestinationNested<A> editDestination() {
        return this.withNewDestinationLike(this.getDestination());
    }

    @Override
    public IngressRuleFluent.DestinationNested<A> editOrNewDestination() {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : new IstioServiceBuilder().build());
    }

    @Override
    public IngressRuleFluent.DestinationNested<A> editOrNewDestinationLike(IstioService item) {
        return this.withNewDestinationLike(this.getDestination() != null ? this.getDestination() : item);
    }

    @Override
    @Deprecated
    public MatchCondition getMatch() {
        return this.match != null ? this.match.build() : null;
    }

    @Override
    public MatchCondition buildMatch() {
        return this.match != null ? this.match.build() : null;
    }

    @Override
    public A withMatch(MatchCondition match) {
        this._visitables.remove(this.match);
        if (match != null) {
            this.match = new MatchConditionBuilder(match);
            this._visitables.add(this.match);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatch() {
        return this.match != null;
    }

    @Override
    public IngressRuleFluent.MatchNested<A> withNewMatch() {
        return new MatchNestedImpl();
    }

    @Override
    public IngressRuleFluent.MatchNested<A> withNewMatchLike(MatchCondition item) {
        return new MatchNestedImpl(item);
    }

    @Override
    public IngressRuleFluent.MatchNested<A> editMatch() {
        return this.withNewMatchLike(this.getMatch());
    }

    @Override
    public IngressRuleFluent.MatchNested<A> editOrNewMatch() {
        return this.withNewMatchLike(this.getMatch() != null ? this.getMatch() : new MatchConditionBuilder().build());
    }

    @Override
    public IngressRuleFluent.MatchNested<A> editOrNewMatchLike(MatchCondition item) {
        return this.withNewMatchLike(this.getMatch() != null ? this.getMatch() : item);
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A withNewPort(int arg1) {
        return this.withPort(new Integer(arg1));
    }

    @Override
    public A withNewPort(String arg1) {
        return this.withPort(new Integer(arg1));
    }

    @Override
    public Integer getPrecedence() {
        return this.precedence;
    }

    @Override
    public A withPrecedence(Integer precedence) {
        this.precedence = precedence;
        return (A)this;
    }

    @Override
    public Boolean hasPrecedence() {
        return this.precedence != null;
    }

    @Override
    public A withNewPrecedence(int arg1) {
        return this.withPrecedence(new Integer(arg1));
    }

    @Override
    public A withNewPrecedence(String arg1) {
        return this.withPrecedence(new Integer(arg1));
    }

    @Override
    public String getTlsSecret() {
        return this.tlsSecret;
    }

    @Override
    public A withTlsSecret(String tlsSecret) {
        this.tlsSecret = tlsSecret;
        return (A)this;
    }

    @Override
    public Boolean hasTlsSecret() {
        return this.tlsSecret != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressRuleFluentImpl that = (IngressRuleFluentImpl)o;
        if (this.destinationServicePort != null && this.destinationServicePort != this ? !this.destinationServicePort.equals(that.destinationServicePort) : that.destinationServicePort != null && this.destinationServicePort != this) {
            return false;
        }
        if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) {
            return false;
        }
        if (this.match != null ? !this.match.equals(that.match) : that.match != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.precedence != null ? !this.precedence.equals(that.precedence) : that.precedence != null) {
            return false;
        }
        return !(this.tlsSecret != null ? !this.tlsSecret.equals(that.tlsSecret) : that.tlsSecret != null);
    }

    public class MatchNestedImpl<N>
    extends MatchConditionFluentImpl<IngressRuleFluent.MatchNested<N>>
    implements IngressRuleFluent.MatchNested<N>,
    Nested<N> {
        private final MatchConditionBuilder builder;

        MatchNestedImpl(MatchCondition item) {
            this.builder = new MatchConditionBuilder(this, item);
        }

        MatchNestedImpl() {
            this.builder = new MatchConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluentImpl.this.withMatch(this.builder.build());
        }

        @Override
        public N endMatch() {
            return this.and();
        }
    }

    public class DestinationNestedImpl<N>
    extends IstioServiceFluentImpl<IngressRuleFluent.DestinationNested<N>>
    implements IngressRuleFluent.DestinationNested<N>,
    Nested<N> {
        private final IstioServiceBuilder builder;

        DestinationNestedImpl(IstioService item) {
            this.builder = new IstioServiceBuilder(this, item);
        }

        DestinationNestedImpl() {
            this.builder = new IstioServiceBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluentImpl.this.withDestination(this.builder.build());
        }

        @Override
        public N endDestination() {
            return this.and();
        }
    }
}

