/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.routing;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.routing.EgressRule;
import me.snowdrop.istio.api.model.v1.routing.EgressRuleFluent;
import me.snowdrop.istio.api.model.v1.routing.EgressRuleFluentImpl;

public class EgressRuleBuilder
extends EgressRuleFluentImpl<EgressRuleBuilder>
implements VisitableBuilder<EgressRule, EgressRuleBuilder> {
    EgressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public EgressRuleBuilder() {
        this(true);
    }

    public EgressRuleBuilder(Boolean validationEnabled) {
        this(new EgressRule(), validationEnabled);
    }

    public EgressRuleBuilder(EgressRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EgressRuleBuilder(EgressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EgressRule(), validationEnabled);
    }

    public EgressRuleBuilder(EgressRuleFluent<?> fluent, EgressRule instance) {
        this(fluent, instance, true);
    }

    public EgressRuleBuilder(EgressRuleFluent<?> fluent, EgressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDestination(instance.getDestination());
        fluent.withPorts(instance.getPorts());
        fluent.withUseEgressProxy(instance.getUseEgressProxy());
        this.validationEnabled = validationEnabled;
    }

    public EgressRuleBuilder(EgressRule instance) {
        this(instance, (Boolean)true);
    }

    public EgressRuleBuilder(EgressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDestination(instance.getDestination());
        this.withPorts(instance.getPorts());
        this.withUseEgressProxy(instance.getUseEgressProxy());
        this.validationEnabled = validationEnabled;
    }

    public EgressRule build() {
        EgressRule buildable = new EgressRule(this.fluent.getDestination(), this.fluent.getPorts(), this.fluent.isUseEgressProxy());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EgressRuleBuilder that = (EgressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

