/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.rbac;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.rbac.ServiceRoleBinding;
import me.snowdrop.istio.api.model.v1.rbac.ServiceRoleBindingFluent;
import me.snowdrop.istio.api.model.v1.rbac.ServiceRoleBindingFluentImpl;

public class ServiceRoleBindingBuilder
extends ServiceRoleBindingFluentImpl<ServiceRoleBindingBuilder>
implements VisitableBuilder<ServiceRoleBinding, ServiceRoleBindingBuilder> {
    ServiceRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceRoleBindingBuilder() {
        this(true);
    }

    public ServiceRoleBindingBuilder(Boolean validationEnabled) {
        this(new ServiceRoleBinding(), validationEnabled);
    }

    public ServiceRoleBindingBuilder(ServiceRoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceRoleBindingBuilder(ServiceRoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceRoleBinding(), validationEnabled);
    }

    public ServiceRoleBindingBuilder(ServiceRoleBindingFluent<?> fluent, ServiceRoleBinding instance) {
        this(fluent, instance, true);
    }

    public ServiceRoleBindingBuilder(ServiceRoleBindingFluent<?> fluent, ServiceRoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public ServiceRoleBindingBuilder(ServiceRoleBinding instance) {
        this(instance, (Boolean)true);
    }

    public ServiceRoleBindingBuilder(ServiceRoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public ServiceRoleBinding build() {
        ServiceRoleBinding buildable = new ServiceRoleBinding(this.fluent.getRoleRef(), this.fluent.getSubjects());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceRoleBindingBuilder that = (ServiceRoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

