/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.rbac;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.rbac.AccessRule;
import me.snowdrop.istio.api.model.v1.rbac.AccessRuleFluent;
import me.snowdrop.istio.api.model.v1.rbac.Constraint;
import me.snowdrop.istio.api.model.v1.rbac.ConstraintBuilder;
import me.snowdrop.istio.api.model.v1.rbac.ConstraintFluentImpl;

public class AccessRuleFluentImpl<A extends AccessRuleFluent<A>>
extends BaseFluent<A>
implements AccessRuleFluent<A> {
    private List<ConstraintBuilder> constraints;
    private List<String> methods;
    private List<String> paths;
    private List<String> services;

    public AccessRuleFluentImpl() {
    }

    public AccessRuleFluentImpl(AccessRule instance) {
        this.withConstraints(instance.getConstraints());
        this.withMethods(instance.getMethods());
        this.withPaths(instance.getPaths());
        this.withServices(instance.getServices());
    }

    @Override
    public A addToConstraints(int index, Constraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        ConstraintBuilder builder = new ConstraintBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.constraints.add(index >= 0 ? index : this.constraints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConstraints(int index, Constraint item) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        ConstraintBuilder builder = new ConstraintBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.constraints.size()) {
            this.constraints.add(builder);
        } else {
            this.constraints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConstraints(Constraint ... items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConstraints(Collection<Constraint> items) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
        }
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.add(builder);
            this.constraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConstraints(Constraint ... items) {
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.remove(builder);
            if (this.constraints == null) continue;
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConstraints(Collection<Constraint> items) {
        for (Constraint item : items) {
            ConstraintBuilder builder = new ConstraintBuilder(item);
            this._visitables.remove(builder);
            if (this.constraints == null) continue;
            this.constraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Constraint> getConstraints() {
        return AccessRuleFluentImpl.build(this.constraints);
    }

    @Override
    public List<Constraint> buildConstraints() {
        return AccessRuleFluentImpl.build(this.constraints);
    }

    @Override
    public Constraint buildConstraint(int index) {
        return this.constraints.get(index).build();
    }

    @Override
    public Constraint buildFirstConstraint() {
        return this.constraints.get(0).build();
    }

    @Override
    public Constraint buildLastConstraint() {
        return this.constraints.get(this.constraints.size() - 1).build();
    }

    @Override
    public Constraint buildMatchingConstraint(Predicate<ConstraintBuilder> predicate) {
        for (ConstraintBuilder item : this.constraints) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConstraints(List<Constraint> constraints) {
        if (this.constraints != null) {
            this._visitables.removeAll(this.constraints);
        }
        if (constraints != null) {
            this.constraints = new ArrayList<ConstraintBuilder>();
            for (Constraint item : constraints) {
                this.addToConstraints(item);
            }
        } else {
            this.constraints = null;
        }
        return (A)this;
    }

    @Override
    public A withConstraints(Constraint ... constraints) {
        this.constraints.clear();
        if (constraints != null) {
            for (Constraint item : constraints) {
                this.addToConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConstraints() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraint() {
        return new ConstraintsNestedImpl();
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> addNewConstraintLike(Constraint item) {
        return new ConstraintsNestedImpl(-1, item);
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> setNewConstraintLike(int index, Constraint item) {
        return new ConstraintsNestedImpl(index, item);
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editConstraint(int index) {
        if (this.constraints.size() <= index) {
            throw new RuntimeException("Can't edit constraints. Index exceeds size.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editFirstConstraint() {
        if (this.constraints.size() == 0) {
            throw new RuntimeException("Can't edit first constraints. The list is empty.");
        }
        return this.setNewConstraintLike(0, this.buildConstraint(0));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editLastConstraint() {
        int index = this.constraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last constraints. The list is empty.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public AccessRuleFluent.ConstraintsNested<A> editMatchingConstraint(Predicate<ConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!predicate.apply((Object)this.constraints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching constraints. No match found.");
        }
        return this.setNewConstraintLike(index, this.buildConstraint(index));
    }

    @Override
    public A addToMethods(int index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMethods(int index, String item) {
        this.methods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMethods(String ... items) {
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMethods(Collection<String> items) {
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMethods(String ... items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMethods(Collection<String> items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public String getMethod(int index) {
        return this.methods.get(index);
    }

    @Override
    public String getFirstMethod() {
        return this.methods.get(0);
    }

    @Override
    public String getLastMethod() {
        return this.methods.get(this.methods.size() - 1);
    }

    @Override
    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withMethods(List<String> methods) {
        if (this.methods != null) {
            this._visitables.removeAll(this.methods);
        }
        if (methods != null) {
            this.methods = new ArrayList<String>();
            for (String item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)this;
    }

    @Override
    public A withMethods(String ... methods) {
        this.methods.clear();
        if (methods != null) {
            for (String item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    @Override
    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, String item) {
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(int index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (this.paths != null) {
            this._visitables.removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        this.paths.clear();
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addToServices(int index, String item) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServices(int index, String item) {
        this.services.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServices(String ... items) {
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServices(Collection<String> items) {
        for (String item : items) {
            this.services.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServices(String ... items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServices(Collection<String> items) {
        for (String item : items) {
            if (this.services == null) continue;
            this.services.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServices() {
        return this.services;
    }

    @Override
    public String getService(int index) {
        return this.services.get(index);
    }

    @Override
    public String getFirstService() {
        return this.services.get(0);
    }

    @Override
    public String getLastService() {
        return this.services.get(this.services.size() - 1);
    }

    @Override
    public String getMatchingService(Predicate<String> predicate) {
        for (String item : this.services) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withServices(List<String> services) {
        if (this.services != null) {
            this._visitables.removeAll(this.services);
        }
        if (services != null) {
            this.services = new ArrayList<String>();
            for (String item : services) {
                this.addToServices(item);
            }
        } else {
            this.services = null;
        }
        return (A)this;
    }

    @Override
    public A withServices(String ... services) {
        this.services.clear();
        if (services != null) {
            for (String item : services) {
                this.addToServices(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServices() {
        return this.services != null && !this.services.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccessRuleFluentImpl that = (AccessRuleFluentImpl)o;
        if (this.constraints != null ? !this.constraints.equals(that.constraints) : that.constraints != null) {
            return false;
        }
        if (this.methods != null ? !this.methods.equals(that.methods) : that.methods != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.services != null ? !this.services.equals(that.services) : that.services != null);
    }

    public class ConstraintsNestedImpl<N>
    extends ConstraintFluentImpl<AccessRuleFluent.ConstraintsNested<N>>
    implements AccessRuleFluent.ConstraintsNested<N>,
    Nested<N> {
        private final ConstraintBuilder builder;
        private final int index;

        ConstraintsNestedImpl(int index, Constraint item) {
            this.index = index;
            this.builder = new ConstraintBuilder(this, item);
        }

        ConstraintsNestedImpl() {
            this.index = -1;
            this.builder = new ConstraintBuilder(this);
        }

        @Override
        public N and() {
            return (N)AccessRuleFluentImpl.this.setToConstraints(this.index, this.builder.build());
        }

        @Override
        public N endConstraint() {
            return this.and();
        }
    }
}

