/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.HTTPRoute;
import me.snowdrop.istio.api.model.v1.networking.HTTPRouteBuilder;
import me.snowdrop.istio.api.model.v1.networking.HTTPRouteFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.TCPRoute;
import me.snowdrop.istio.api.model.v1.networking.TCPRouteBuilder;
import me.snowdrop.istio.api.model.v1.networking.TCPRouteFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.VirtualService;
import me.snowdrop.istio.api.model.v1.networking.VirtualServiceFluent;

public class VirtualServiceFluentImpl<A extends VirtualServiceFluent<A>>
extends BaseFluent<A>
implements VirtualServiceFluent<A> {
    private List<String> gateways;
    private List<String> hosts;
    private List<HTTPRouteBuilder> http;
    private List<TCPRouteBuilder> tcp;

    public VirtualServiceFluentImpl() {
    }

    public VirtualServiceFluentImpl(VirtualService instance) {
        this.withGateways(instance.getGateways());
        this.withHosts(instance.getHosts());
        this.withHttp(instance.getHttp());
        this.withTcp(instance.getTcp());
    }

    @Override
    public A addToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGateways(int index, String item) {
        this.gateways.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGateways(String ... items) {
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGateways(Collection<String> items) {
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGateways(String ... items) {
        for (String item : items) {
            if (this.gateways == null) continue;
            this.gateways.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGateways(Collection<String> items) {
        for (String item : items) {
            if (this.gateways == null) continue;
            this.gateways.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGateways() {
        return this.gateways;
    }

    @Override
    public String getGateway(int index) {
        return this.gateways.get(index);
    }

    @Override
    public String getFirstGateway() {
        return this.gateways.get(0);
    }

    @Override
    public String getLastGateway() {
        return this.gateways.get(this.gateways.size() - 1);
    }

    @Override
    public String getMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGateways(List<String> gateways) {
        if (this.gateways != null) {
            this._visitables.removeAll(this.gateways);
        }
        if (gateways != null) {
            this.gateways = new ArrayList<String>();
            for (String item : gateways) {
                this.addToGateways(item);
            }
        } else {
            this.gateways = null;
        }
        return (A)this;
    }

    @Override
    public A withGateways(String ... gateways) {
        this.gateways.clear();
        if (gateways != null) {
            for (String item : gateways) {
                this.addToGateways(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGateways() {
        return this.gateways != null && !this.gateways.isEmpty();
    }

    @Override
    public A addToHosts(int index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(int index, String item) {
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(int index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (this.hosts != null) {
            this._visitables.removeAll(this.hosts);
        }
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        this.hosts.clear();
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addToHttp(int index, HTTPRoute item) {
        if (this.http == null) {
            this.http = new ArrayList<HTTPRouteBuilder>();
        }
        HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.http.add(index >= 0 ? index : this.http.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHttp(int index, HTTPRoute item) {
        if (this.http == null) {
            this.http = new ArrayList<HTTPRouteBuilder>();
        }
        HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.http.size()) {
            this.http.add(builder);
        } else {
            this.http.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHttp(HTTPRoute ... items) {
        if (this.http == null) {
            this.http = new ArrayList<HTTPRouteBuilder>();
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.add(builder);
            this.http.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHttp(Collection<HTTPRoute> items) {
        if (this.http == null) {
            this.http = new ArrayList<HTTPRouteBuilder>();
        }
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.add(builder);
            this.http.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHttp(HTTPRoute ... items) {
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.remove(builder);
            if (this.http == null) continue;
            this.http.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHttp(Collection<HTTPRoute> items) {
        for (HTTPRoute item : items) {
            HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
            this._visitables.remove(builder);
            if (this.http == null) continue;
            this.http.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPRoute> getHttp() {
        return VirtualServiceFluentImpl.build(this.http);
    }

    @Override
    public List<HTTPRoute> buildHttp() {
        return VirtualServiceFluentImpl.build(this.http);
    }

    @Override
    public HTTPRoute buildHttp(int index) {
        return this.http.get(index).build();
    }

    @Override
    public HTTPRoute buildFirstHttp() {
        return this.http.get(0).build();
    }

    @Override
    public HTTPRoute buildLastHttp() {
        return this.http.get(this.http.size() - 1).build();
    }

    @Override
    public HTTPRoute buildMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
        for (HTTPRouteBuilder item : this.http) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withHttp(List<HTTPRoute> http) {
        if (this.http != null) {
            this._visitables.removeAll(this.http);
        }
        if (http != null) {
            this.http = new ArrayList<HTTPRouteBuilder>();
            for (HTTPRoute item : http) {
                this.addToHttp(item);
            }
        } else {
            this.http = null;
        }
        return (A)this;
    }

    @Override
    public A withHttp(HTTPRoute ... http) {
        this.http.clear();
        if (http != null) {
            for (HTTPRoute item : http) {
                this.addToHttp(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttp() {
        return this.http != null && !this.http.isEmpty();
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> addNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> addNewHttpLike(HTTPRoute item) {
        return new HttpNestedImpl(-1, item);
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> setNewHttpLike(int index, HTTPRoute item) {
        return new HttpNestedImpl(index, item);
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> editHttp(int index) {
        if (this.http.size() <= index) {
            throw new RuntimeException("Can't edit http. Index exceeds size.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> editFirstHttp() {
        if (this.http.size() == 0) {
            throw new RuntimeException("Can't edit first http. The list is empty.");
        }
        return this.setNewHttpLike(0, this.buildHttp(0));
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> editLastHttp() {
        int index = this.http.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last http. The list is empty.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    @Override
    public VirtualServiceFluent.HttpNested<A> editMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.http.size(); ++i) {
            if (!predicate.apply((Object)this.http.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching http. No match found.");
        }
        return this.setNewHttpLike(index, this.buildHttp(index));
    }

    @Override
    public A addToTcp(int index, TCPRoute item) {
        if (this.tcp == null) {
            this.tcp = new ArrayList<TCPRouteBuilder>();
        }
        TCPRouteBuilder builder = new TCPRouteBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.tcp.add(index >= 0 ? index : this.tcp.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTcp(int index, TCPRoute item) {
        if (this.tcp == null) {
            this.tcp = new ArrayList<TCPRouteBuilder>();
        }
        TCPRouteBuilder builder = new TCPRouteBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.tcp.size()) {
            this.tcp.add(builder);
        } else {
            this.tcp.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTcp(TCPRoute ... items) {
        if (this.tcp == null) {
            this.tcp = new ArrayList<TCPRouteBuilder>();
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.add(builder);
            this.tcp.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTcp(Collection<TCPRoute> items) {
        if (this.tcp == null) {
            this.tcp = new ArrayList<TCPRouteBuilder>();
        }
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.add(builder);
            this.tcp.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTcp(TCPRoute ... items) {
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.remove(builder);
            if (this.tcp == null) continue;
            this.tcp.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTcp(Collection<TCPRoute> items) {
        for (TCPRoute item : items) {
            TCPRouteBuilder builder = new TCPRouteBuilder(item);
            this._visitables.remove(builder);
            if (this.tcp == null) continue;
            this.tcp.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TCPRoute> getTcp() {
        return VirtualServiceFluentImpl.build(this.tcp);
    }

    @Override
    public List<TCPRoute> buildTcp() {
        return VirtualServiceFluentImpl.build(this.tcp);
    }

    @Override
    public TCPRoute buildTcp(int index) {
        return this.tcp.get(index).build();
    }

    @Override
    public TCPRoute buildFirstTcp() {
        return this.tcp.get(0).build();
    }

    @Override
    public TCPRoute buildLastTcp() {
        return this.tcp.get(this.tcp.size() - 1).build();
    }

    @Override
    public TCPRoute buildMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
        for (TCPRouteBuilder item : this.tcp) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTcp(List<TCPRoute> tcp) {
        if (this.tcp != null) {
            this._visitables.removeAll(this.tcp);
        }
        if (tcp != null) {
            this.tcp = new ArrayList<TCPRouteBuilder>();
            for (TCPRoute item : tcp) {
                this.addToTcp(item);
            }
        } else {
            this.tcp = null;
        }
        return (A)this;
    }

    @Override
    public A withTcp(TCPRoute ... tcp) {
        this.tcp.clear();
        if (tcp != null) {
            for (TCPRoute item : tcp) {
                this.addToTcp(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTcp() {
        return this.tcp != null && !this.tcp.isEmpty();
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> addNewTcp() {
        return new TcpNestedImpl();
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> addNewTcpLike(TCPRoute item) {
        return new TcpNestedImpl(-1, item);
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> setNewTcpLike(int index, TCPRoute item) {
        return new TcpNestedImpl(index, item);
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> editTcp(int index) {
        if (this.tcp.size() <= index) {
            throw new RuntimeException("Can't edit tcp. Index exceeds size.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> editFirstTcp() {
        if (this.tcp.size() == 0) {
            throw new RuntimeException("Can't edit first tcp. The list is empty.");
        }
        return this.setNewTcpLike(0, this.buildTcp(0));
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> editLastTcp() {
        int index = this.tcp.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tcp. The list is empty.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    @Override
    public VirtualServiceFluent.TcpNested<A> editMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tcp.size(); ++i) {
            if (!predicate.apply((Object)this.tcp.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tcp. No match found.");
        }
        return this.setNewTcpLike(index, this.buildTcp(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VirtualServiceFluentImpl that = (VirtualServiceFluentImpl)o;
        if (this.gateways != null ? !this.gateways.equals(that.gateways) : that.gateways != null) {
            return false;
        }
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return !(this.tcp != null ? !this.tcp.equals(that.tcp) : that.tcp != null);
    }

    public class TcpNestedImpl<N>
    extends TCPRouteFluentImpl<VirtualServiceFluent.TcpNested<N>>
    implements VirtualServiceFluent.TcpNested<N>,
    Nested<N> {
        private final TCPRouteBuilder builder;
        private final int index;

        TcpNestedImpl(int index, TCPRoute item) {
            this.index = index;
            this.builder = new TCPRouteBuilder(this, item);
        }

        TcpNestedImpl() {
            this.index = -1;
            this.builder = new TCPRouteBuilder(this);
        }

        @Override
        public N and() {
            return (N)VirtualServiceFluentImpl.this.setToTcp(this.index, this.builder.build());
        }

        @Override
        public N endTcp() {
            return this.and();
        }
    }

    public class HttpNestedImpl<N>
    extends HTTPRouteFluentImpl<VirtualServiceFluent.HttpNested<N>>
    implements VirtualServiceFluent.HttpNested<N>,
    Nested<N> {
        private final HTTPRouteBuilder builder;
        private final int index;

        HttpNestedImpl(int index, HTTPRoute item) {
            this.index = index;
            this.builder = new HTTPRouteBuilder(this, item);
        }

        HttpNestedImpl() {
            this.index = -1;
            this.builder = new HTTPRouteBuilder(this);
        }

        @Override
        public N and() {
            return (N)VirtualServiceFluentImpl.this.setToHttp(this.index, this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

