/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.snowdrop.istio.api.model.v1.networking.ConnectionPoolSettings;
import me.snowdrop.istio.api.model.v1.networking.ConnectionPoolSettingsBuilder;
import me.snowdrop.istio.api.model.v1.networking.ConnectionPoolSettingsFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.LoadBalancerSettings;
import me.snowdrop.istio.api.model.v1.networking.LoadBalancerSettingsBuilder;
import me.snowdrop.istio.api.model.v1.networking.LoadBalancerSettingsFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.OutlierDetection;
import me.snowdrop.istio.api.model.v1.networking.OutlierDetectionBuilder;
import me.snowdrop.istio.api.model.v1.networking.OutlierDetectionFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.PortTrafficPolicy;
import me.snowdrop.istio.api.model.v1.networking.PortTrafficPolicyBuilder;
import me.snowdrop.istio.api.model.v1.networking.PortTrafficPolicyFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.TLSSettings;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsBuilder;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsFluentImpl;
import me.snowdrop.istio.api.model.v1.networking.TrafficPolicy;
import me.snowdrop.istio.api.model.v1.networking.TrafficPolicyFluent;

public class TrafficPolicyFluentImpl<A extends TrafficPolicyFluent<A>>
extends BaseFluent<A>
implements TrafficPolicyFluent<A> {
    private ConnectionPoolSettingsBuilder connectionPool;
    private LoadBalancerSettingsBuilder loadBalancer;
    private OutlierDetectionBuilder outlierDetection;
    private List<PortTrafficPolicyBuilder> portLevelSettings;
    private TLSSettingsBuilder tls;

    public TrafficPolicyFluentImpl() {
    }

    public TrafficPolicyFluentImpl(TrafficPolicy instance) {
        this.withConnectionPool(instance.getConnectionPool());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withOutlierDetection(instance.getOutlierDetection());
        this.withPortLevelSettings(instance.getPortLevelSettings());
        this.withTls(instance.getTls());
    }

    @Override
    @Deprecated
    public ConnectionPoolSettings getConnectionPool() {
        return this.connectionPool != null ? this.connectionPool.build() : null;
    }

    @Override
    public ConnectionPoolSettings buildConnectionPool() {
        return this.connectionPool != null ? this.connectionPool.build() : null;
    }

    @Override
    public A withConnectionPool(ConnectionPoolSettings connectionPool) {
        this._visitables.remove(this.connectionPool);
        if (connectionPool != null) {
            this.connectionPool = new ConnectionPoolSettingsBuilder(connectionPool);
            this._visitables.add(this.connectionPool);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConnectionPool() {
        return this.connectionPool != null;
    }

    @Override
    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool() {
        return new ConnectionPoolNestedImpl();
    }

    @Override
    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
        return new ConnectionPoolNestedImpl(item);
    }

    @Override
    public TrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool() {
        return this.withNewConnectionPoolLike(this.getConnectionPool());
    }

    @Override
    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool() {
        return this.withNewConnectionPoolLike(this.getConnectionPool() != null ? this.getConnectionPool() : new ConnectionPoolSettingsBuilder().build());
    }

    @Override
    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
        return this.withNewConnectionPoolLike(this.getConnectionPool() != null ? this.getConnectionPool() : item);
    }

    @Override
    @Deprecated
    public LoadBalancerSettings getLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public LoadBalancerSettings buildLoadBalancer() {
        return this.loadBalancer != null ? this.loadBalancer.build() : null;
    }

    @Override
    public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
        this._visitables.remove(this.loadBalancer);
        if (loadBalancer != null) {
            this.loadBalancer = new LoadBalancerSettingsBuilder(loadBalancer);
            this._visitables.add(this.loadBalancer);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLoadBalancer() {
        return this.loadBalancer != null;
    }

    @Override
    public A withNewLoadBalancer(Object lbPolicy) {
        return this.withLoadBalancer(new LoadBalancerSettings(lbPolicy));
    }

    @Override
    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer() {
        return new LoadBalancerNestedImpl();
    }

    @Override
    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
        return new LoadBalancerNestedImpl(item);
    }

    @Override
    public TrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer());
    }

    @Override
    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : new LoadBalancerSettingsBuilder().build());
    }

    @Override
    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
        return this.withNewLoadBalancerLike(this.getLoadBalancer() != null ? this.getLoadBalancer() : item);
    }

    @Override
    @Deprecated
    public OutlierDetection getOutlierDetection() {
        return this.outlierDetection != null ? this.outlierDetection.build() : null;
    }

    @Override
    public OutlierDetection buildOutlierDetection() {
        return this.outlierDetection != null ? this.outlierDetection.build() : null;
    }

    @Override
    public A withOutlierDetection(OutlierDetection outlierDetection) {
        this._visitables.remove(this.outlierDetection);
        if (outlierDetection != null) {
            this.outlierDetection = new OutlierDetectionBuilder(outlierDetection);
            this._visitables.add(this.outlierDetection);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutlierDetection() {
        return this.outlierDetection != null;
    }

    @Override
    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection() {
        return new OutlierDetectionNestedImpl();
    }

    @Override
    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
        return new OutlierDetectionNestedImpl(item);
    }

    @Override
    public TrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection() {
        return this.withNewOutlierDetectionLike(this.getOutlierDetection());
    }

    @Override
    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection() {
        return this.withNewOutlierDetectionLike(this.getOutlierDetection() != null ? this.getOutlierDetection() : new OutlierDetectionBuilder().build());
    }

    @Override
    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
        return this.withNewOutlierDetectionLike(this.getOutlierDetection() != null ? this.getOutlierDetection() : item);
    }

    @Override
    public A addToPortLevelSettings(int index, PortTrafficPolicy item) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();
        }
        PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.portLevelSettings.add(index >= 0 ? index : this.portLevelSettings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPortLevelSettings(int index, PortTrafficPolicy item) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();
        }
        PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.portLevelSettings.size()) {
            this.portLevelSettings.add(builder);
        } else {
            this.portLevelSettings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPortLevelSettings(PortTrafficPolicy ... items) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();
        }
        for (PortTrafficPolicy item : items) {
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
            this._visitables.add(builder);
            this.portLevelSettings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortLevelSettings(Collection<PortTrafficPolicy> items) {
        if (this.portLevelSettings == null) {
            this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();
        }
        for (PortTrafficPolicy item : items) {
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
            this._visitables.add(builder);
            this.portLevelSettings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortLevelSettings(PortTrafficPolicy ... items) {
        for (PortTrafficPolicy item : items) {
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
            this._visitables.remove(builder);
            if (this.portLevelSettings == null) continue;
            this.portLevelSettings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortLevelSettings(Collection<PortTrafficPolicy> items) {
        for (PortTrafficPolicy item : items) {
            PortTrafficPolicyBuilder builder = new PortTrafficPolicyBuilder(item);
            this._visitables.remove(builder);
            if (this.portLevelSettings == null) continue;
            this.portLevelSettings.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PortTrafficPolicy> getPortLevelSettings() {
        return TrafficPolicyFluentImpl.build(this.portLevelSettings);
    }

    @Override
    public List<PortTrafficPolicy> buildPortLevelSettings() {
        return TrafficPolicyFluentImpl.build(this.portLevelSettings);
    }

    @Override
    public PortTrafficPolicy buildPortLevelSetting(int index) {
        return this.portLevelSettings.get(index).build();
    }

    @Override
    public PortTrafficPolicy buildFirstPortLevelSetting() {
        return this.portLevelSettings.get(0).build();
    }

    @Override
    public PortTrafficPolicy buildLastPortLevelSetting() {
        return this.portLevelSettings.get(this.portLevelSettings.size() - 1).build();
    }

    @Override
    public PortTrafficPolicy buildMatchingPortLevelSetting(Predicate<PortTrafficPolicyBuilder> predicate) {
        for (PortTrafficPolicyBuilder item : this.portLevelSettings) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPortLevelSettings(List<PortTrafficPolicy> portLevelSettings) {
        if (this.portLevelSettings != null) {
            this._visitables.removeAll(this.portLevelSettings);
        }
        if (portLevelSettings != null) {
            this.portLevelSettings = new ArrayList<PortTrafficPolicyBuilder>();
            for (PortTrafficPolicy item : portLevelSettings) {
                this.addToPortLevelSettings(item);
            }
        } else {
            this.portLevelSettings = null;
        }
        return (A)this;
    }

    @Override
    public A withPortLevelSettings(PortTrafficPolicy ... portLevelSettings) {
        this.portLevelSettings.clear();
        if (portLevelSettings != null) {
            for (PortTrafficPolicy item : portLevelSettings) {
                this.addToPortLevelSettings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortLevelSettings() {
        return this.portLevelSettings != null && !this.portLevelSettings.isEmpty();
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSetting() {
        return new PortLevelSettingsNestedImpl();
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSettingLike(PortTrafficPolicy item) {
        return new PortLevelSettingsNestedImpl(-1, item);
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> setNewPortLevelSettingLike(int index, PortTrafficPolicy item) {
        return new PortLevelSettingsNestedImpl(index, item);
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> editPortLevelSetting(int index) {
        if (this.portLevelSettings.size() <= index) {
            throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> editFirstPortLevelSetting() {
        if (this.portLevelSettings.size() == 0) {
            throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
        }
        return this.setNewPortLevelSettingLike(0, this.buildPortLevelSetting(0));
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> editLastPortLevelSetting() {
        int index = this.portLevelSettings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    @Override
    public TrafficPolicyFluent.PortLevelSettingsNested<A> editMatchingPortLevelSetting(Predicate<PortTrafficPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.portLevelSettings.size(); ++i) {
            if (!predicate.apply((Object)this.portLevelSettings.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
        }
        return this.setNewPortLevelSettingLike(index, this.buildPortLevelSetting(index));
    }

    @Override
    @Deprecated
    public TLSSettings getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public TLSSettings buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(TLSSettings tls) {
        this._visitables.remove(this.tls);
        if (tls != null) {
            this.tls = new TLSSettingsBuilder(tls);
            this._visitables.add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public TrafficPolicyFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public TrafficPolicyFluent.TlsNested<A> withNewTlsLike(TLSSettings item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public TrafficPolicyFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public TrafficPolicyFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new TLSSettingsBuilder().build());
    }

    @Override
    public TrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(TLSSettings item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TrafficPolicyFluentImpl that = (TrafficPolicyFluentImpl)o;
        if (this.connectionPool != null ? !this.connectionPool.equals(that.connectionPool) : that.connectionPool != null) {
            return false;
        }
        if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) {
            return false;
        }
        if (this.outlierDetection != null ? !this.outlierDetection.equals(that.outlierDetection) : that.outlierDetection != null) {
            return false;
        }
        if (this.portLevelSettings != null ? !this.portLevelSettings.equals(that.portLevelSettings) : that.portLevelSettings != null) {
            return false;
        }
        return !(this.tls != null ? !this.tls.equals(that.tls) : that.tls != null);
    }

    public class TlsNestedImpl<N>
    extends TLSSettingsFluentImpl<TrafficPolicyFluent.TlsNested<N>>
    implements TrafficPolicyFluent.TlsNested<N>,
    Nested<N> {
        private final TLSSettingsBuilder builder;

        TlsNestedImpl(TLSSettings item) {
            this.builder = new TLSSettingsBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new TLSSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TrafficPolicyFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class PortLevelSettingsNestedImpl<N>
    extends PortTrafficPolicyFluentImpl<TrafficPolicyFluent.PortLevelSettingsNested<N>>
    implements TrafficPolicyFluent.PortLevelSettingsNested<N>,
    Nested<N> {
        private final PortTrafficPolicyBuilder builder;
        private final int index;

        PortLevelSettingsNestedImpl(int index, PortTrafficPolicy item) {
            this.index = index;
            this.builder = new PortTrafficPolicyBuilder(this, item);
        }

        PortLevelSettingsNestedImpl() {
            this.index = -1;
            this.builder = new PortTrafficPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)TrafficPolicyFluentImpl.this.setToPortLevelSettings(this.index, this.builder.build());
        }

        @Override
        public N endPortLevelSetting() {
            return this.and();
        }
    }

    public class OutlierDetectionNestedImpl<N>
    extends OutlierDetectionFluentImpl<TrafficPolicyFluent.OutlierDetectionNested<N>>
    implements TrafficPolicyFluent.OutlierDetectionNested<N>,
    Nested<N> {
        private final OutlierDetectionBuilder builder;

        OutlierDetectionNestedImpl(OutlierDetection item) {
            this.builder = new OutlierDetectionBuilder(this, item);
        }

        OutlierDetectionNestedImpl() {
            this.builder = new OutlierDetectionBuilder(this);
        }

        @Override
        public N and() {
            return (N)TrafficPolicyFluentImpl.this.withOutlierDetection(this.builder.build());
        }

        @Override
        public N endOutlierDetection() {
            return this.and();
        }
    }

    public class LoadBalancerNestedImpl<N>
    extends LoadBalancerSettingsFluentImpl<TrafficPolicyFluent.LoadBalancerNested<N>>
    implements TrafficPolicyFluent.LoadBalancerNested<N>,
    Nested<N> {
        private final LoadBalancerSettingsBuilder builder;

        LoadBalancerNestedImpl(LoadBalancerSettings item) {
            this.builder = new LoadBalancerSettingsBuilder(this, item);
        }

        LoadBalancerNestedImpl() {
            this.builder = new LoadBalancerSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TrafficPolicyFluentImpl.this.withLoadBalancer(this.builder.build());
        }

        @Override
        public N endLoadBalancer() {
            return this.and();
        }
    }

    public class ConnectionPoolNestedImpl<N>
    extends ConnectionPoolSettingsFluentImpl<TrafficPolicyFluent.ConnectionPoolNested<N>>
    implements TrafficPolicyFluent.ConnectionPoolNested<N>,
    Nested<N> {
        private final ConnectionPoolSettingsBuilder builder;

        ConnectionPoolNestedImpl(ConnectionPoolSettings item) {
            this.builder = new ConnectionPoolSettingsBuilder(this, item);
        }

        ConnectionPoolNestedImpl() {
            this.builder = new ConnectionPoolSettingsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TrafficPolicyFluentImpl.this.withConnectionPool(this.builder.build());
        }

        @Override
        public N endConnectionPool() {
            return this.and();
        }
    }
}

