/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.api.model.v1.networking;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import me.snowdrop.istio.api.model.v1.networking.TLSSettings;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsFluent;
import me.snowdrop.istio.api.model.v1.networking.TLSSettingsFluentImpl;

public class TLSSettingsBuilder
extends TLSSettingsFluentImpl<TLSSettingsBuilder>
implements VisitableBuilder<TLSSettings, TLSSettingsBuilder> {
    TLSSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public TLSSettingsBuilder() {
        this(true);
    }

    public TLSSettingsBuilder(Boolean validationEnabled) {
        this(new TLSSettings(), validationEnabled);
    }

    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TLSSettings(), validationEnabled);
    }

    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent, TLSSettings instance) {
        this(fluent, instance, true);
    }

    public TLSSettingsBuilder(TLSSettingsFluent<?> fluent, TLSSettings instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCaCertificates(instance.getCaCertificates());
        fluent.withClientCertificate(instance.getClientCertificate());
        fluent.withMode(instance.getMode());
        fluent.withPrivateKey(instance.getPrivateKey());
        fluent.withSni(instance.getSni());
        fluent.withSubjectAltNames(instance.getSubjectAltNames());
        this.validationEnabled = validationEnabled;
    }

    public TLSSettingsBuilder(TLSSettings instance) {
        this(instance, (Boolean)true);
    }

    public TLSSettingsBuilder(TLSSettings instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCaCertificates(instance.getCaCertificates());
        this.withClientCertificate(instance.getClientCertificate());
        this.withMode(instance.getMode());
        this.withPrivateKey(instance.getPrivateKey());
        this.withSni(instance.getSni());
        this.withSubjectAltNames(instance.getSubjectAltNames());
        this.validationEnabled = validationEnabled;
    }

    public TLSSettings build() {
        TLSSettings buildable = new TLSSettings(this.fluent.getCaCertificates(), this.fluent.getClientCertificate(), this.fluent.getMode(), this.fluent.getPrivateKey(), this.fluent.getSni(), this.fluent.getSubjectAltNames());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TLSSettingsBuilder that = (TLSSettingsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

